%------------------------------------------------------------------------------
% File     : DAT212^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Data Structures
% Problem  : Splay tree analysis 136
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [Nip14] Nipkow (2014), Amortized Complexity Verified
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : splay_tree_analysis__136.p [Bla16]

% Status   : Theorem
% Rating   : 1.00 v7.2.0, 0.75 v7.1.0
% Syntax   : Number of formulae    :  343 (  47 unt;  57 typ;   0 def)
%            Number of atoms       : 1084 ( 230 equ;   0 cnn)
%            Maximal formula atoms :   16 (   3 avg)
%            Number of connectives : 4824 ( 123   ~;  18   |;  91   &;3949   @)
%                                         (   0 <=>; 643  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   22 (  10 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :  150 ( 150   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   56 (  55 usr;   8 con; 0-4 aty)
%            Number of variables   : 1183 (  34   ^;1058   !;  46   ?;1183   :)
%                                         (  45  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:49:24.843
%------------------------------------------------------------------------------
%----Could-be-implicit typings (5)
thf(ty_t_Tree_Otree,type,
    tree: $tType > $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

thf(ty_tf_a,type,
    a: $tType ).

%----Explicit typings (52)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Ono__bot,type,
    no_bot: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Ono__top,type,
    no_top: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Owellorder,type,
    wellorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Odense__order,type,
    dense_order: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Odense__linorder,type,
    dense_linorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Divides_Osemiring__numeral__div,type,
    semiring_numeral_div: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__ab__semigroup__add,type,
    ordere779506340up_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocanonically__ordered__monoid__add,type,
    canoni770627133id_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__cancel__ab__semigroup__add,type,
    ordere223160158up_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ostrict__ordered__ab__semigroup__add,type,
    strict2144017051up_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Conditionally__Complete__Lattices_Olinear__continuum,type,
    condit1656338222tinuum: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Conditionally__Complete__Lattices_Oconditionally__complete__linorder,type,
    condit1037483654norder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

thf(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Pure_Otype,type,
    type2: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Set_OBall,type,
    ball: 
      !>[A: $tType] : ( ( set @ A ) > ( A > $o ) > $o ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Splay__Tree_Ois__root,type,
    splay_is_root: 
      !>[A: $tType] : ( A > ( tree @ A ) > $o ) ).

thf(sy_c_Splay__Tree_Osplay,type,
    splay_splay: 
      !>[A: $tType] : ( A > ( tree @ A ) > ( tree @ A ) ) ).

thf(sy_c_Splay__Tree_Osplay__max,type,
    splay_splay_max: 
      !>[A: $tType] : ( ( tree @ A ) > ( tree @ A ) ) ).

thf(sy_c_Splay__Tree__Analysis__Base_Ot__splay,type,
    splay_914434265_splay: 
      !>[A: $tType] : ( A > ( tree @ A ) > nat ) ).

thf(sy_c_Splay__Tree__Analysis__Base_Ot__splay__max,type,
    splay_878424299ay_max: 
      !>[A: $tType] : ( ( tree @ A ) > nat ) ).

thf(sy_c_Tree_Olinorder__class_Obst,type,
    linorder_bst: 
      !>[A: $tType] : ( ( tree @ A ) > $o ) ).

thf(sy_c_Tree_Olinorder__class_Obst__eq,type,
    linorder_bst_eq: 
      !>[A: $tType] : ( ( tree @ A ) > $o ) ).

thf(sy_c_Tree_Olinorder__class_Obst__eq__rel,type,
    linorder_bst_eq_rel: 
      !>[A: $tType] : ( ( tree @ A ) > ( tree @ A ) > $o ) ).

thf(sy_c_Tree_Olinorder__class_Obst__rel,type,
    linorder_bst_rel: 
      !>[A: $tType] : ( ( tree @ A ) > ( tree @ A ) > $o ) ).

thf(sy_c_Tree_Osubtrees,type,
    subtrees: 
      !>[A: $tType] : ( ( tree @ A ) > ( set @ ( tree @ A ) ) ) ).

thf(sy_c_Tree_Otree_OLeaf,type,
    leaf: 
      !>[A: $tType] : ( tree @ A ) ).

thf(sy_c_Tree_Otree_ONode,type,
    node: 
      !>[A: $tType] : ( ( tree @ A ) > A > ( tree @ A ) > ( tree @ A ) ) ).

thf(sy_c_Tree_Otree_Omap__tree,type,
    map_tree: 
      !>[A: $tType,Aa: $tType] : ( ( A > Aa ) > ( tree @ A ) > ( tree @ Aa ) ) ).

thf(sy_c_Tree_Otree_Opred__tree,type,
    pred_tree: 
      !>[A: $tType] : ( ( A > $o ) > ( tree @ A ) > $o ) ).

thf(sy_c_Tree_Otree_Oset__tree,type,
    set_tree: 
      !>[A: $tType] : ( ( tree @ A ) > ( set @ A ) ) ).

thf(sy_c_Wellfounded_Oaccp,type,
    accp: 
      !>[A: $tType] : ( ( A > A > $o ) > A > $o ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_a____,type,
    a2: a ).

thf(sy_v_b____,type,
    b: a ).

thf(sy_v_la____,type,
    la: tree @ a ).

thf(sy_v_lb____,type,
    lb: tree @ a ).

thf(sy_v_lx,type,
    lx: tree @ a ).

thf(sy_v_rb____,type,
    rb: tree @ a ).

thf(sy_v_rx,type,
    rx: tree @ a ).

thf(sy_v_xa____,type,
    xa: a ).

%----Relevant facts (256)
thf(fact_0__C11_Ohyps_C_I2_J,axiom,
    ord_less @ a @ xa @ b ).

% "11.hyps"(2)
thf(fact_1__C11_Ohyps_C_I1_J,axiom,
    ord_less @ a @ a2 @ xa ).

% "11.hyps"(1)
thf(fact_2__C0_C,axiom,
    ( ~ ( member @ a @ xa @ ( set_tree @ a @ rb ) )
    & ~ ( member @ a @ xa @ ( set_tree @ a @ la ) ) ) ).

% "0"
thf(fact_3__C11_Oprems_C_I1_J,axiom,
    linorder_bst @ a @ ( node @ a @ la @ a2 @ ( node @ a @ lb @ b @ rb ) ) ).

% "11.prems"(1)
thf(fact_4__C11_Oprems_C_I2_J,axiom,
    member @ ( tree @ a ) @ ( node @ a @ lx @ xa @ rx ) @ ( subtrees @ a @ ( node @ a @ la @ a2 @ ( node @ a @ lb @ b @ rb ) ) ) ).

% "11.prems"(2)
thf(fact_5__C11_Ohyps_C_I3_J,axiom,
    ( lb
   != ( leaf @ a ) ) ).

% "11.hyps"(3)
thf(fact_6_tree_Oset__intros_I3_J,axiom,
    ! [A: $tType,Xa: A,A3: tree @ A,A1: tree @ A,A2: A] :
      ( ( member @ A @ Xa @ ( set_tree @ A @ A3 ) )
     => ( member @ A @ Xa @ ( set_tree @ A @ ( node @ A @ A1 @ A2 @ A3 ) ) ) ) ).

% tree.set_intros(3)
thf(fact_7_tree_Oset__intros_I2_J,axiom,
    ! [A: $tType,A2: A,A1: tree @ A,A3: tree @ A] : ( member @ A @ A2 @ ( set_tree @ A @ ( node @ A @ A1 @ A2 @ A3 ) ) ) ).

% tree.set_intros(2)
thf(fact_8_tree_Oset__intros_I1_J,axiom,
    ! [A: $tType,X: A,A1: tree @ A,A2: A,A3: tree @ A] :
      ( ( member @ A @ X @ ( set_tree @ A @ A1 ) )
     => ( member @ A @ X @ ( set_tree @ A @ ( node @ A @ A1 @ A2 @ A3 ) ) ) ) ).

% tree.set_intros(1)
thf(fact_9_tree_Oset__cases,axiom,
    ! [A: $tType,E: A,A4: tree @ A] :
      ( ( member @ A @ E @ ( set_tree @ A @ A4 ) )
     => ( ! [Z1: tree @ A] :
            ( ? [Z2: A,Z3: tree @ A] :
                ( A4
                = ( node @ A @ Z1 @ Z2 @ Z3 ) )
           => ~ ( member @ A @ E @ ( set_tree @ A @ Z1 ) ) )
       => ( ! [Z1: tree @ A,Z3: tree @ A] :
              ( A4
             != ( node @ A @ Z1 @ E @ Z3 ) )
         => ~ ! [Z1: tree @ A,Z2: A,Z3: tree @ A] :
                ( ( A4
                  = ( node @ A @ Z1 @ Z2 @ Z3 ) )
               => ~ ( member @ A @ E @ ( set_tree @ A @ Z3 ) ) ) ) ) ) ).

% tree.set_cases
thf(fact_10_set__treeE,axiom,
    ! [A: $tType,A4: A,T: tree @ A] :
      ( ( member @ A @ A4 @ ( set_tree @ A @ T ) )
     => ? [L: tree @ A,R: tree @ A] : ( member @ ( tree @ A ) @ ( node @ A @ L @ A4 @ R ) @ ( subtrees @ A @ T ) ) ) ).

% set_treeE
thf(fact_11_in__set__tree__if,axiom,
    ! [A: $tType,L2: tree @ A,A4: A,R2: tree @ A,T: tree @ A] :
      ( ( member @ ( tree @ A ) @ ( node @ A @ L2 @ A4 @ R2 ) @ ( subtrees @ A @ T ) )
     => ( member @ A @ A4 @ ( set_tree @ A @ T ) ) ) ).

% in_set_tree_if
thf(fact_12_Node__notin__subtrees__if,axiom,
    ! [A: $tType,A4: A,T: tree @ A,L2: tree @ A,R2: tree @ A] :
      ( ~ ( member @ A @ A4 @ ( set_tree @ A @ T ) )
     => ~ ( member @ ( tree @ A ) @ ( node @ A @ L2 @ A4 @ R2 ) @ ( subtrees @ A @ T ) ) ) ).

% Node_notin_subtrees_if
thf(fact_13_set__splay__max,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: tree @ A] :
          ( ( set_tree @ A @ ( splay_splay_max @ A @ T ) )
          = ( set_tree @ A @ T ) ) ) ).

% set_splay_max
thf(fact_14_tree_Opred__cong,axiom,
    ! [A: $tType,X: tree @ A,Ya: tree @ A,P: A > $o,Pa: A > $o] :
      ( ( X = Ya )
     => ( ! [Z: A] :
            ( ( member @ A @ Z @ ( set_tree @ A @ Ya ) )
           => ( ( P @ Z )
              = ( Pa @ Z ) ) )
       => ( ( pred_tree @ A @ P @ X )
          = ( pred_tree @ A @ Pa @ Ya ) ) ) ) ).

% tree.pred_cong
thf(fact_15_tree_Opred__mono__strong,axiom,
    ! [A: $tType,P: A > $o,X: tree @ A,Pa: A > $o] :
      ( ( pred_tree @ A @ P @ X )
     => ( ! [Z: A] :
            ( ( member @ A @ Z @ ( set_tree @ A @ X ) )
           => ( ( P @ Z )
             => ( Pa @ Z ) ) )
       => ( pred_tree @ A @ Pa @ X ) ) ) ).

% tree.pred_mono_strong
thf(fact_16_tree_Omap__cong,axiom,
    ! [B: $tType,A: $tType,X: tree @ A,Ya: tree @ A,F: A > B,G: A > B] :
      ( ( X = Ya )
     => ( ! [Z: A] :
            ( ( member @ A @ Z @ ( set_tree @ A @ Ya ) )
           => ( ( F @ Z )
              = ( G @ Z ) ) )
       => ( ( map_tree @ A @ B @ F @ X )
          = ( map_tree @ A @ B @ G @ Ya ) ) ) ) ).

% tree.map_cong
thf(fact_17_tree_Omap__cong0,axiom,
    ! [B: $tType,A: $tType,X: tree @ A,F: A > B,G: A > B] :
      ( ! [Z: A] :
          ( ( member @ A @ Z @ ( set_tree @ A @ X ) )
         => ( ( F @ Z )
            = ( G @ Z ) ) )
     => ( ( map_tree @ A @ B @ F @ X )
        = ( map_tree @ A @ B @ G @ X ) ) ) ).

% tree.map_cong0
thf(fact_18_tree_Oinject,axiom,
    ! [A: $tType,X21: tree @ A,X22: A,X23: tree @ A,Y21: tree @ A,Y22: A,Y23: tree @ A] :
      ( ( ( node @ A @ X21 @ X22 @ X23 )
        = ( node @ A @ Y21 @ Y22 @ Y23 ) )
      = ( ( X21 = Y21 )
        & ( X22 = Y22 )
        & ( X23 = Y23 ) ) ) ).

% tree.inject
thf(fact_19_tree_Opred__inject_I2_J,axiom,
    ! [A: $tType,P: A > $o,A4: tree @ A,Aa2: A,Ab: tree @ A] :
      ( ( pred_tree @ A @ P @ ( node @ A @ A4 @ Aa2 @ Ab ) )
      = ( ( pred_tree @ A @ P @ A4 )
        & ( P @ Aa2 )
        & ( pred_tree @ A @ P @ Ab ) ) ) ).

% tree.pred_inject(2)
thf(fact_20_splay__max__Leaf__iff,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: tree @ A] :
          ( ( ( splay_splay_max @ A @ T )
            = ( leaf @ A ) )
          = ( T
            = ( leaf @ A ) ) ) ) ).

% splay_max_Leaf_iff
thf(fact_21_tree_Osimps_I9_J,axiom,
    ! [B: $tType,A: $tType,F: A > B,X21: tree @ A,X22: A,X23: tree @ A] :
      ( ( map_tree @ A @ B @ F @ ( node @ A @ X21 @ X22 @ X23 ) )
      = ( node @ B @ ( map_tree @ A @ B @ F @ X21 ) @ ( F @ X22 ) @ ( map_tree @ A @ B @ F @ X23 ) ) ) ).

% tree.simps(9)
thf(fact_22_tree_Osimps_I8_J,axiom,
    ! [A: $tType,B: $tType,F: A > B] :
      ( ( map_tree @ A @ B @ F @ ( leaf @ A ) )
      = ( leaf @ B ) ) ).

% tree.simps(8)
thf(fact_23_tree_Odistinct_I1_J,axiom,
    ! [A: $tType,X21: tree @ A,X22: A,X23: tree @ A] :
      ( ( leaf @ A )
     != ( node @ A @ X21 @ X22 @ X23 ) ) ).

% tree.distinct(1)
thf(fact_24_tree_Opred__inject_I1_J,axiom,
    ! [A: $tType,P: A > $o] : ( pred_tree @ A @ P @ ( leaf @ A ) ) ).

% tree.pred_inject(1)
thf(fact_25_splay__max_Osimps_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [La: tree @ A,A4: A] :
          ( ( splay_splay_max @ A @ ( node @ A @ La @ A4 @ ( leaf @ A ) ) )
          = ( node @ A @ La @ A4 @ ( leaf @ A ) ) ) ) ).

% splay_max.simps(2)
thf(fact_26_splay__max_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( ( splay_splay_max @ A @ ( leaf @ A ) )
        = ( leaf @ A ) ) ) ).

% splay_max.simps(1)
thf(fact_27_bst_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( linorder_bst @ A @ ( leaf @ A ) ) ) ).

% bst.simps(1)
thf(fact_28_tree_Oinduct,axiom,
    ! [A: $tType,P: ( tree @ A ) > $o,Tree: tree @ A] :
      ( ( P @ ( leaf @ A ) )
     => ( ! [X1: tree @ A,X2: A,X3: tree @ A] :
            ( ( P @ X1 )
           => ( ( P @ X3 )
             => ( P @ ( node @ A @ X1 @ X2 @ X3 ) ) ) )
       => ( P @ Tree ) ) ) ).

% tree.induct
thf(fact_29_neq__Leaf__iff,axiom,
    ! [A: $tType,T: tree @ A] :
      ( ( T
       != ( leaf @ A ) )
      = ( ? [L3: tree @ A,A5: A,R3: tree @ A] :
            ( T
            = ( node @ A @ L3 @ A5 @ R3 ) ) ) ) ).

% neq_Leaf_iff
thf(fact_30_tree_Oexhaust,axiom,
    ! [A: $tType,Y: tree @ A] :
      ( ( Y
       != ( leaf @ A ) )
     => ~ ! [X212: tree @ A,X222: A,X232: tree @ A] :
            ( Y
           != ( node @ A @ X212 @ X222 @ X232 ) ) ) ).

% tree.exhaust
thf(fact_31_mirror_Oinduct,axiom,
    ! [A: $tType,P: ( tree @ A ) > $o,A0: tree @ A] :
      ( ( P @ ( leaf @ A ) )
     => ( ! [L: tree @ A,X4: A,R: tree @ A] :
            ( ( P @ R )
           => ( ( P @ L )
             => ( P @ ( node @ A @ L @ X4 @ R ) ) ) )
       => ( P @ A0 ) ) ) ).

% mirror.induct
thf(fact_32_bst__splay__max,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: tree @ A] :
          ( ( linorder_bst @ A @ T )
         => ( linorder_bst @ A @ ( splay_splay_max @ A @ T ) ) ) ) ).

% bst_splay_max
thf(fact_33_splay__max__Leaf,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: tree @ A,L2: tree @ A,A4: A,R2: tree @ A] :
          ( ( ( splay_splay_max @ A @ T )
            = ( node @ A @ L2 @ A4 @ R2 ) )
         => ( R2
            = ( leaf @ A ) ) ) ) ).

% splay_max_Leaf
thf(fact_34_bst__eq_Ocases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: tree @ A] :
          ( ( X
           != ( leaf @ A ) )
         => ~ ! [L: tree @ A,A6: A,R: tree @ A] :
                ( X
               != ( node @ A @ L @ A6 @ R ) ) ) ) ).

% bst_eq.cases
thf(fact_35_bst__eq_Oinduct,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: ( tree @ A ) > $o,A0: tree @ A] :
          ( ( P @ ( leaf @ A ) )
         => ( ! [L: tree @ A,A6: A,R: tree @ A] :
                ( ( P @ L )
               => ( ( P @ R )
                 => ( P @ ( node @ A @ L @ A6 @ R ) ) ) )
           => ( P @ A0 ) ) ) ) ).

% bst_eq.induct
thf(fact_36_tree_Oinj__map__strong,axiom,
    ! [B: $tType,A: $tType,X: tree @ A,Xa: tree @ A,F: A > B,Fa: A > B] :
      ( ! [Z: A,Za: A] :
          ( ( member @ A @ Z @ ( set_tree @ A @ X ) )
         => ( ( member @ A @ Za @ ( set_tree @ A @ Xa ) )
           => ( ( ( F @ Z )
                = ( Fa @ Za ) )
             => ( Z = Za ) ) ) )
     => ( ( ( map_tree @ A @ B @ F @ X )
          = ( map_tree @ A @ B @ Fa @ Xa ) )
       => ( X = Xa ) ) ) ).

% tree.inj_map_strong
thf(fact_37__092_060Phi_062_Ocases,axiom,
    ! [A: $tType,X: tree @ A] :
      ( ( X
       != ( leaf @ A ) )
     => ~ ! [L: tree @ A,A6: A,R: tree @ A] :
            ( X
           != ( node @ A @ L @ A6 @ R ) ) ) ).

% \<Phi>.cases
thf(fact_38__092_060Phi_062_Oinduct,axiom,
    ! [A: $tType,P: ( tree @ A ) > $o,A0: tree @ A] :
      ( ( P @ ( leaf @ A ) )
     => ( ! [L: tree @ A,A6: A,R: tree @ A] :
            ( ( P @ L )
           => ( ( P @ R )
             => ( P @ ( node @ A @ L @ A6 @ R ) ) ) )
       => ( P @ A0 ) ) ) ).

% \<Phi>.induct
thf(fact_39_t__splay__max_Ocases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: tree @ A] :
          ( ( X
           != ( leaf @ A ) )
         => ( ! [L: tree @ A,B2: A] :
                ( X
               != ( node @ A @ L @ B2 @ ( leaf @ A ) ) )
           => ~ ! [L: tree @ A,B2: A,Rl: tree @ A,C: A,Rr: tree @ A] :
                  ( X
                 != ( node @ A @ L @ B2 @ ( node @ A @ Rl @ C @ Rr ) ) ) ) ) ) ).

% t_splay_max.cases
thf(fact_40_t__splay__max_Oinduct,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: ( tree @ A ) > $o,A0: tree @ A] :
          ( ( P @ ( leaf @ A ) )
         => ( ! [L: tree @ A,B2: A] : ( P @ ( node @ A @ L @ B2 @ ( leaf @ A ) ) )
           => ( ! [L: tree @ A,B2: A,Rl: tree @ A,C: A,Rr: tree @ A] :
                  ( ( ( Rr
                     != ( leaf @ A ) )
                   => ( P @ Rr ) )
                 => ( P @ ( node @ A @ L @ B2 @ ( node @ A @ Rl @ C @ Rr ) ) ) )
             => ( P @ A0 ) ) ) ) ) ).

% t_splay_max.induct
thf(fact_41_bst_Oelims_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: tree @ A] :
          ( ( linorder_bst @ A @ X )
         => ( ( X
             != ( leaf @ A ) )
           => ~ ! [L: tree @ A,A6: A,R: tree @ A] :
                  ( ( X
                    = ( node @ A @ L @ A6 @ R ) )
                 => ~ ( ( linorder_bst @ A @ L )
                      & ( linorder_bst @ A @ R )
                      & ! [X5: A] :
                          ( ( member @ A @ X5 @ ( set_tree @ A @ L ) )
                         => ( ord_less @ A @ X5 @ A6 ) )
                      & ! [X5: A] :
                          ( ( member @ A @ X5 @ ( set_tree @ A @ R ) )
                         => ( ord_less @ A @ A6 @ X5 ) ) ) ) ) ) ) ).

% bst.elims(2)
thf(fact_42_bst_Oelims_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: tree @ A,Y: $o] :
          ( ( ( linorder_bst @ A @ X )
            = Y )
         => ( ( ( X
                = ( leaf @ A ) )
             => ~ Y )
           => ~ ! [L: tree @ A,A6: A,R: tree @ A] :
                  ( ( X
                    = ( node @ A @ L @ A6 @ R ) )
                 => ( Y
                    = ( ~ ( ( linorder_bst @ A @ L )
                          & ( linorder_bst @ A @ R )
                          & ! [X6: A] :
                              ( ( member @ A @ X6 @ ( set_tree @ A @ L ) )
                             => ( ord_less @ A @ X6 @ A6 ) )
                          & ! [X6: A] :
                              ( ( member @ A @ X6 @ ( set_tree @ A @ R ) )
                             => ( ord_less @ A @ A6 @ X6 ) ) ) ) ) ) ) ) ) ).

% bst.elims(1)
thf(fact_43_splay__bstL,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: tree @ A,A4: A,L2: tree @ A,E: A,R2: tree @ A,X: A] :
          ( ( linorder_bst @ A @ T )
         => ( ( ( splay_splay @ A @ A4 @ T )
              = ( node @ A @ L2 @ E @ R2 ) )
           => ( ( member @ A @ X @ ( set_tree @ A @ L2 ) )
             => ( ord_less @ A @ X @ A4 ) ) ) ) ) ).

% splay_bstL
thf(fact_44_splay__bstR,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: tree @ A,A4: A,L2: tree @ A,E: A,R2: tree @ A,X: A] :
          ( ( linorder_bst @ A @ T )
         => ( ( ( splay_splay @ A @ A4 @ T )
              = ( node @ A @ L2 @ E @ R2 ) )
           => ( ( member @ A @ X @ ( set_tree @ A @ R2 ) )
             => ( ord_less @ A @ A4 @ X ) ) ) ) ) ).

% splay_bstR
thf(fact_45_mem__Collect__eq,axiom,
    ! [A: $tType,A4: A,P: A > $o] :
      ( ( member @ A @ A4 @ ( collect @ A @ P ) )
      = ( P @ A4 ) ) ).

% mem_Collect_eq
thf(fact_46_Collect__mem__eq,axiom,
    ! [A: $tType,A7: set @ A] :
      ( ( collect @ A
        @ ^ [X6: A] : ( member @ A @ X6 @ A7 ) )
      = A7 ) ).

% Collect_mem_eq
thf(fact_47_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X4: A] :
          ( ( P @ X4 )
          = ( Q @ X4 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_48_ext,axiom,
    ! [B: $tType,A: $tType,F: A > B,G: A > B] :
      ( ! [X4: A] :
          ( ( F @ X4 )
          = ( G @ X4 ) )
     => ( F = G ) ) ).

% ext
thf(fact_49_bst_Oelims_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: tree @ A] :
          ( ~ ( linorder_bst @ A @ X )
         => ~ ! [L: tree @ A,A6: A,R: tree @ A] :
                ( ( X
                  = ( node @ A @ L @ A6 @ R ) )
               => ( ( linorder_bst @ A @ L )
                  & ( linorder_bst @ A @ R )
                  & ! [X4: A] :
                      ( ( member @ A @ X4 @ ( set_tree @ A @ L ) )
                     => ( ord_less @ A @ X4 @ A6 ) )
                  & ! [X4: A] :
                      ( ( member @ A @ X4 @ ( set_tree @ A @ R ) )
                     => ( ord_less @ A @ A6 @ X4 ) ) ) ) ) ) ).

% bst.elims(3)
thf(fact_50_bst_Osimps_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [L2: tree @ A,A4: A,R2: tree @ A] :
          ( ( linorder_bst @ A @ ( node @ A @ L2 @ A4 @ R2 ) )
          = ( ( linorder_bst @ A @ L2 )
            & ( linorder_bst @ A @ R2 )
            & ! [X6: A] :
                ( ( member @ A @ X6 @ ( set_tree @ A @ L2 ) )
               => ( ord_less @ A @ X6 @ A4 ) )
            & ! [X6: A] :
                ( ( member @ A @ X6 @ ( set_tree @ A @ R2 ) )
               => ( ord_less @ A @ A4 @ X6 ) ) ) ) ) ).

% bst.simps(2)
thf(fact_51_splay__Leaf__iff,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A4: A,T: tree @ A] :
          ( ( ( splay_splay @ A @ A4 @ T )
            = ( leaf @ A ) )
          = ( T
            = ( leaf @ A ) ) ) ) ).

% splay_Leaf_iff
thf(fact_52_splay_Osimps_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A4: A,L2: tree @ A,R2: tree @ A] :
          ( ( splay_splay @ A @ A4 @ ( node @ A @ L2 @ A4 @ R2 ) )
          = ( node @ A @ L2 @ A4 @ R2 ) ) ) ).

% splay.simps(2)
thf(fact_53_splay_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A4: A] :
          ( ( splay_splay @ A @ A4 @ ( leaf @ A ) )
          = ( leaf @ A ) ) ) ).

% splay.simps(1)
thf(fact_54_set__splay,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A4: A,T: tree @ A] :
          ( ( set_tree @ A @ ( splay_splay @ A @ A4 @ T ) )
          = ( set_tree @ A @ T ) ) ) ).

% set_splay
thf(fact_55_bst__splay,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: tree @ A,A4: A] :
          ( ( linorder_bst @ A @ T )
         => ( linorder_bst @ A @ ( splay_splay @ A @ A4 @ T ) ) ) ) ).

% bst_splay
thf(fact_56_splay_Osimps_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A,La: tree @ A,Ra: tree @ A,Rb: tree @ A] :
          ( ( ord_less @ A @ A4 @ B3 )
         => ( ( splay_splay @ A @ A4 @ ( node @ A @ ( node @ A @ La @ A4 @ Ra ) @ B3 @ Rb ) )
            = ( node @ A @ La @ A4 @ ( node @ A @ Ra @ B3 @ Rb ) ) ) ) ) ).

% splay.simps(3)
thf(fact_57_splay_Osimps_I9_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [B3: A,A4: A,Lb: tree @ A,La: tree @ A,Ra: tree @ A] :
          ( ( ord_less @ A @ B3 @ A4 )
         => ( ( splay_splay @ A @ A4 @ ( node @ A @ Lb @ B3 @ ( node @ A @ La @ A4 @ Ra ) ) )
            = ( node @ A @ ( node @ A @ Lb @ B3 @ La ) @ A4 @ Ra ) ) ) ) ).

% splay.simps(9)
thf(fact_58_splay__not__Leaf,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: tree @ A,A4: A] :
          ( ( T
           != ( leaf @ A ) )
         => ? [L: tree @ A,X4: A,R: tree @ A] :
              ( ( splay_splay @ A @ A4 @ T )
              = ( node @ A @ L @ X4 @ R ) ) ) ) ).

% splay_not_Leaf
thf(fact_59_tree_Opred__set,axiom,
    ! [A: $tType] :
      ( ( pred_tree @ A )
      = ( ^ [P2: A > $o,X6: tree @ A] :
          ! [Y2: A] :
            ( ( member @ A @ Y2 @ ( set_tree @ A @ X6 ) )
           => ( P2 @ Y2 ) ) ) ) ).

% tree.pred_set
thf(fact_60_splay__max__eq__splay__ex,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: tree @ A] :
          ( ( linorder_bst @ A @ T )
         => ? [A6: A] :
              ( ( splay_splay_max @ A @ T )
              = ( splay_splay @ A @ A6 @ T ) ) ) ) ).

% splay_max_eq_splay_ex
thf(fact_61_splay_Osimps_I4_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A,R2: tree @ A] :
          ( ( ord_less @ A @ A4 @ B3 )
         => ( ( splay_splay @ A @ A4 @ ( node @ A @ ( leaf @ A ) @ B3 @ R2 ) )
            = ( node @ A @ ( leaf @ A ) @ B3 @ R2 ) ) ) ) ).

% splay.simps(4)
thf(fact_62_splay_Osimps_I5_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,A4: A,B3: A,Ra: tree @ A,Rb: tree @ A] :
          ( ( ord_less @ A @ X @ A4 )
         => ( ( ord_less @ A @ X @ B3 )
           => ( ( splay_splay @ A @ X @ ( node @ A @ ( node @ A @ ( leaf @ A ) @ A4 @ Ra ) @ B3 @ Rb ) )
              = ( node @ A @ ( leaf @ A ) @ A4 @ ( node @ A @ Ra @ B3 @ Rb ) ) ) ) ) ) ).

% splay.simps(5)
thf(fact_63_splay_Osimps_I7_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,B3: A,A4: A,La: tree @ A,Rb: tree @ A] :
          ( ( ord_less @ A @ X @ B3 )
         => ( ( ord_less @ A @ A4 @ X )
           => ( ( splay_splay @ A @ X @ ( node @ A @ ( node @ A @ La @ A4 @ ( leaf @ A ) ) @ B3 @ Rb ) )
              = ( node @ A @ La @ A4 @ ( node @ A @ ( leaf @ A ) @ B3 @ Rb ) ) ) ) ) ) ).

% splay.simps(7)
thf(fact_64_splay_Osimps_I10_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A4: A,X: A,L2: tree @ A] :
          ( ( ord_less @ A @ A4 @ X )
         => ( ( splay_splay @ A @ X @ ( node @ A @ L2 @ A4 @ ( leaf @ A ) ) )
            = ( node @ A @ L2 @ A4 @ ( leaf @ A ) ) ) ) ) ).

% splay.simps(10)
thf(fact_65_splay_Osimps_I12_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A4: A,X: A,B3: A,La: tree @ A,Rb: tree @ A] :
          ( ( ord_less @ A @ A4 @ X )
         => ( ( ord_less @ A @ X @ B3 )
           => ( ( splay_splay @ A @ X @ ( node @ A @ La @ A4 @ ( node @ A @ ( leaf @ A ) @ B3 @ Rb ) ) )
              = ( node @ A @ ( node @ A @ La @ A4 @ ( leaf @ A ) ) @ B3 @ Rb ) ) ) ) ) ).

% splay.simps(12)
thf(fact_66_splay_Osimps_I13_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A4: A,X: A,B3: A,La: tree @ A,Lb: tree @ A] :
          ( ( ord_less @ A @ A4 @ X )
         => ( ( ord_less @ A @ B3 @ X )
           => ( ( splay_splay @ A @ X @ ( node @ A @ La @ A4 @ ( node @ A @ Lb @ B3 @ ( leaf @ A ) ) ) )
              = ( node @ A @ ( node @ A @ La @ A4 @ Lb ) @ B3 @ ( leaf @ A ) ) ) ) ) ) ).

% splay.simps(13)
thf(fact_67_splay__to__root,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: tree @ A,A4: A,T2: tree @ A] :
          ( ( linorder_bst @ A @ T )
         => ( ( ( splay_splay @ A @ A4 @ T )
              = T2 )
           => ( ( member @ A @ A4 @ ( set_tree @ A @ T ) )
              = ( ? [L3: tree @ A,R3: tree @ A] :
                    ( T2
                    = ( node @ A @ L3 @ A4 @ R3 ) ) ) ) ) ) ) ).

% splay_to_root
thf(fact_68_is__root__splay,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: tree @ A,A4: A] :
          ( ( linorder_bst @ A @ T )
         => ( ( splay_is_root @ A @ A4 @ ( splay_splay @ A @ A4 @ T ) )
            = ( member @ A @ A4 @ ( set_tree @ A @ T ) ) ) ) ) ).

% is_root_splay
thf(fact_69_ex__in__set__tree,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: tree @ A,A4: A] :
          ( ( T
           != ( leaf @ A ) )
         => ( ( linorder_bst @ A @ T )
           => ? [X4: A] :
                ( ( member @ A @ X4 @ ( set_tree @ A @ T ) )
                & ( ( splay_splay @ A @ X4 @ T )
                  = ( splay_splay @ A @ A4 @ T ) )
                & ( ( splay_914434265_splay @ A @ X4 @ T )
                  = ( splay_914434265_splay @ A @ A4 @ T ) ) ) ) ) ) ).

% ex_in_set_tree
thf(fact_70_splay__max__eq__splay,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: tree @ A,A4: A] :
          ( ( linorder_bst @ A @ T )
         => ( ! [X4: A] :
                ( ( member @ A @ X4 @ ( set_tree @ A @ T ) )
               => ( ord_less_eq @ A @ X4 @ A4 ) )
           => ( ( splay_splay_max @ A @ T )
              = ( splay_splay @ A @ A4 @ T ) ) ) ) ) ).

% splay_max_eq_splay
thf(fact_71_bst_Opelims_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: tree @ A,Y: $o] :
          ( ( ( linorder_bst @ A @ X )
            = Y )
         => ( ( accp @ ( tree @ A ) @ ( linorder_bst_rel @ A ) @ X )
           => ( ( ( X
                  = ( leaf @ A ) )
               => ( Y
                 => ~ ( accp @ ( tree @ A ) @ ( linorder_bst_rel @ A ) @ ( leaf @ A ) ) ) )
             => ~ ! [L: tree @ A,A6: A,R: tree @ A] :
                    ( ( X
                      = ( node @ A @ L @ A6 @ R ) )
                   => ( ( Y
                        = ( ( linorder_bst @ A @ L )
                          & ( linorder_bst @ A @ R )
                          & ! [X6: A] :
                              ( ( member @ A @ X6 @ ( set_tree @ A @ L ) )
                             => ( ord_less @ A @ X6 @ A6 ) )
                          & ! [X6: A] :
                              ( ( member @ A @ X6 @ ( set_tree @ A @ R ) )
                             => ( ord_less @ A @ A6 @ X6 ) ) ) )
                     => ~ ( accp @ ( tree @ A ) @ ( linorder_bst_rel @ A ) @ ( node @ A @ L @ A6 @ R ) ) ) ) ) ) ) ) ).

% bst.pelims(1)
thf(fact_72_bst_Opelims_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: tree @ A] :
          ( ( linorder_bst @ A @ X )
         => ( ( accp @ ( tree @ A ) @ ( linorder_bst_rel @ A ) @ X )
           => ( ( ( X
                  = ( leaf @ A ) )
               => ~ ( accp @ ( tree @ A ) @ ( linorder_bst_rel @ A ) @ ( leaf @ A ) ) )
             => ~ ! [L: tree @ A,A6: A,R: tree @ A] :
                    ( ( X
                      = ( node @ A @ L @ A6 @ R ) )
                   => ( ( accp @ ( tree @ A ) @ ( linorder_bst_rel @ A ) @ ( node @ A @ L @ A6 @ R ) )
                     => ~ ( ( linorder_bst @ A @ L )
                          & ( linorder_bst @ A @ R )
                          & ! [X5: A] :
                              ( ( member @ A @ X5 @ ( set_tree @ A @ L ) )
                             => ( ord_less @ A @ X5 @ A6 ) )
                          & ! [X5: A] :
                              ( ( member @ A @ X5 @ ( set_tree @ A @ R ) )
                             => ( ord_less @ A @ A6 @ X5 ) ) ) ) ) ) ) ) ) ).

% bst.pelims(2)
thf(fact_73_ball__reg,axiom,
    ! [A: $tType,R4: set @ A,P: A > $o,Q: A > $o] :
      ( ! [X4: A] :
          ( ( member @ A @ X4 @ R4 )
         => ( ( P @ X4 )
           => ( Q @ X4 ) ) )
     => ( ! [X4: A] :
            ( ( member @ A @ X4 @ R4 )
           => ( P @ X4 ) )
       => ! [X5: A] :
            ( ( member @ A @ X5 @ R4 )
           => ( Q @ X5 ) ) ) ) ).

% ball_reg
thf(fact_74_Ball__def,axiom,
    ! [A: $tType] :
      ( ( ball @ A )
      = ( ^ [A8: set @ A,P2: A > $o] :
          ! [X6: A] :
            ( ( member @ A @ X6 @ A8 )
           => ( P2 @ X6 ) ) ) ) ).

% Ball_def
thf(fact_75_ex__gt__or__lt,axiom,
    ! [A: $tType] :
      ( ( condit1656338222tinuum @ A @ ( type2 @ A ) )
     => ! [A4: A] :
        ? [B2: A] :
          ( ( ord_less @ A @ A4 @ B2 )
          | ( ord_less @ A @ B2 @ A4 ) ) ) ).

% ex_gt_or_lt
thf(fact_76_complete__interval,axiom,
    ! [A: $tType] :
      ( ( condit1037483654norder @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A,P: A > $o] :
          ( ( ord_less @ A @ A4 @ B3 )
         => ( ( P @ A4 )
           => ( ~ ( P @ B3 )
             => ? [C: A] :
                  ( ( ord_less_eq @ A @ A4 @ C )
                  & ( ord_less_eq @ A @ C @ B3 )
                  & ! [X5: A] :
                      ( ( ( ord_less_eq @ A @ A4 @ X5 )
                        & ( ord_less @ A @ X5 @ C ) )
                     => ( P @ X5 ) )
                  & ! [D: A] :
                      ( ! [X4: A] :
                          ( ( ( ord_less_eq @ A @ A4 @ X4 )
                            & ( ord_less @ A @ X4 @ D ) )
                         => ( P @ X4 ) )
                     => ( ord_less_eq @ A @ D @ C ) ) ) ) ) ) ) ).

% complete_interval
thf(fact_77_bst_Opelims_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: tree @ A] :
          ( ~ ( linorder_bst @ A @ X )
         => ( ( accp @ ( tree @ A ) @ ( linorder_bst_rel @ A ) @ X )
           => ~ ! [L: tree @ A,A6: A,R: tree @ A] :
                  ( ( X
                    = ( node @ A @ L @ A6 @ R ) )
                 => ( ( accp @ ( tree @ A ) @ ( linorder_bst_rel @ A ) @ ( node @ A @ L @ A6 @ R ) )
                   => ( ( linorder_bst @ A @ L )
                      & ( linorder_bst @ A @ R )
                      & ! [X4: A] :
                          ( ( member @ A @ X4 @ ( set_tree @ A @ L ) )
                         => ( ord_less @ A @ X4 @ A6 ) )
                      & ! [X4: A] :
                          ( ( member @ A @ X4 @ ( set_tree @ A @ R ) )
                         => ( ord_less @ A @ A6 @ X4 ) ) ) ) ) ) ) ) ).

% bst.pelims(3)
thf(fact_78_order__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A] : ( ord_less_eq @ A @ X @ X ) ) ).

% order_refl
thf(fact_79_bst__eq_Oelims_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: tree @ A] :
          ( ( linorder_bst_eq @ A @ X )
         => ( ( X
             != ( leaf @ A ) )
           => ~ ! [L: tree @ A,A6: A,R: tree @ A] :
                  ( ( X
                    = ( node @ A @ L @ A6 @ R ) )
                 => ~ ( ( linorder_bst_eq @ A @ L )
                      & ( linorder_bst_eq @ A @ R )
                      & ! [X5: A] :
                          ( ( member @ A @ X5 @ ( set_tree @ A @ L ) )
                         => ( ord_less_eq @ A @ X5 @ A6 ) )
                      & ! [X5: A] :
                          ( ( member @ A @ X5 @ ( set_tree @ A @ R ) )
                         => ( ord_less_eq @ A @ A6 @ X5 ) ) ) ) ) ) ) ).

% bst_eq.elims(2)
thf(fact_80_bst__eq_Oelims_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: tree @ A,Y: $o] :
          ( ( ( linorder_bst_eq @ A @ X )
            = Y )
         => ( ( ( X
                = ( leaf @ A ) )
             => ~ Y )
           => ~ ! [L: tree @ A,A6: A,R: tree @ A] :
                  ( ( X
                    = ( node @ A @ L @ A6 @ R ) )
                 => ( Y
                    = ( ~ ( ( linorder_bst_eq @ A @ L )
                          & ( linorder_bst_eq @ A @ R )
                          & ! [X6: A] :
                              ( ( member @ A @ X6 @ ( set_tree @ A @ L ) )
                             => ( ord_less_eq @ A @ X6 @ A6 ) )
                          & ! [X6: A] :
                              ( ( member @ A @ X6 @ ( set_tree @ A @ R ) )
                             => ( ord_less_eq @ A @ A6 @ X6 ) ) ) ) ) ) ) ) ) ).

% bst_eq.elims(1)
thf(fact_81_order_Onot__eq__order__implies__strict,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A] :
          ( ( A4 != B3 )
         => ( ( ord_less_eq @ A @ A4 @ B3 )
           => ( ord_less @ A @ A4 @ B3 ) ) ) ) ).

% order.not_eq_order_implies_strict
thf(fact_82_dual__order_Ostrict__implies__order,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A4: A] :
          ( ( ord_less @ A @ B3 @ A4 )
         => ( ord_less_eq @ A @ B3 @ A4 ) ) ) ).

% dual_order.strict_implies_order
thf(fact_83_dual__order_Ostrict__iff__order,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less @ A )
        = ( ^ [B4: A,A5: A] :
              ( ( ord_less_eq @ A @ B4 @ A5 )
              & ( A5 != B4 ) ) ) ) ) ).

% dual_order.strict_iff_order
thf(fact_84_bst__eq_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( linorder_bst_eq @ A @ ( leaf @ A ) ) ) ).

% bst_eq.simps(1)
thf(fact_85_bst__eq__if__bst,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: tree @ A] :
          ( ( linorder_bst @ A @ T )
         => ( linorder_bst_eq @ A @ T ) ) ) ).

% bst_eq_if_bst
thf(fact_86_dual__order_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A4: A] :
          ( ( ord_less_eq @ A @ B3 @ A4 )
         => ( ( ord_less_eq @ A @ A4 @ B3 )
           => ( A4 = B3 ) ) ) ) ).

% dual_order.antisym
thf(fact_87_dual__order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A4: A,C2: A] :
          ( ( ord_less_eq @ A @ B3 @ A4 )
         => ( ( ord_less_eq @ A @ C2 @ B3 )
           => ( ord_less_eq @ A @ C2 @ A4 ) ) ) ) ).

% dual_order.trans
thf(fact_88_linorder__wlog,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > A > $o,A4: A,B3: A] :
          ( ! [A6: A,B2: A] :
              ( ( ord_less_eq @ A @ A6 @ B2 )
             => ( P @ A6 @ B2 ) )
         => ( ! [A6: A,B2: A] :
                ( ( P @ B2 @ A6 )
               => ( P @ A6 @ B2 ) )
           => ( P @ A4 @ B3 ) ) ) ) ).

% linorder_wlog
thf(fact_89_dual__order_Orefl,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A4: A] : ( ord_less_eq @ A @ A4 @ A4 ) ) ).

% dual_order.refl
thf(fact_90_order__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z4: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ord_less_eq @ A @ Y @ Z4 )
           => ( ord_less_eq @ A @ X @ Z4 ) ) ) ) ).

% order_trans
thf(fact_91_order__class_Oorder_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A] :
          ( ( ord_less_eq @ A @ A4 @ B3 )
         => ( ( ord_less_eq @ A @ B3 @ A4 )
           => ( A4 = B3 ) ) ) ) ).

% order_class.order.antisym
thf(fact_92_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A,C2: A] :
          ( ( ord_less_eq @ A @ A4 @ B3 )
         => ( ( B3 = C2 )
           => ( ord_less_eq @ A @ A4 @ C2 ) ) ) ) ).

% ord_le_eq_trans
thf(fact_93_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A,C2: A] :
          ( ( A4 = B3 )
         => ( ( ord_less_eq @ A @ B3 @ C2 )
           => ( ord_less_eq @ A @ A4 @ C2 ) ) ) ) ).

% ord_eq_le_trans
thf(fact_94_antisym__conv,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [Y: A,X: A] :
          ( ( ord_less_eq @ A @ Y @ X )
         => ( ( ord_less_eq @ A @ X @ Y )
            = ( X = Y ) ) ) ) ).

% antisym_conv
thf(fact_95_le__cases3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z4: A] :
          ( ( ( ord_less_eq @ A @ X @ Y )
           => ~ ( ord_less_eq @ A @ Y @ Z4 ) )
         => ( ( ( ord_less_eq @ A @ Y @ X )
             => ~ ( ord_less_eq @ A @ X @ Z4 ) )
           => ( ( ( ord_less_eq @ A @ X @ Z4 )
               => ~ ( ord_less_eq @ A @ Z4 @ Y ) )
             => ( ( ( ord_less_eq @ A @ Z4 @ Y )
                 => ~ ( ord_less_eq @ A @ Y @ X ) )
               => ( ( ( ord_less_eq @ A @ Y @ Z4 )
                   => ~ ( ord_less_eq @ A @ Z4 @ X ) )
                 => ~ ( ( ord_less_eq @ A @ Z4 @ X )
                     => ~ ( ord_less_eq @ A @ X @ Y ) ) ) ) ) ) ) ) ).

% le_cases3
thf(fact_96_order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A,C2: A] :
          ( ( ord_less_eq @ A @ A4 @ B3 )
         => ( ( ord_less_eq @ A @ B3 @ C2 )
           => ( ord_less_eq @ A @ A4 @ C2 ) ) ) ) ).

% order.trans
thf(fact_97_le__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ~ ( ord_less_eq @ A @ X @ Y )
         => ( ord_less_eq @ A @ Y @ X ) ) ) ).

% le_cases
thf(fact_98_eq__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( X = Y )
         => ( ord_less_eq @ A @ X @ Y ) ) ) ).

% eq_refl
thf(fact_99_linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
          | ( ord_less_eq @ A @ Y @ X ) ) ) ).

% linear
thf(fact_100_antisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ord_less_eq @ A @ Y @ X )
           => ( X = Y ) ) ) ) ).

% antisym
thf(fact_101_eq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ^ [Y3: A,Z5: A] : ( Y3 = Z5 ) )
        = ( ^ [X6: A,Y2: A] :
              ( ( ord_less_eq @ A @ X6 @ Y2 )
              & ( ord_less_eq @ A @ Y2 @ X6 ) ) ) ) ) ).

% eq_iff
thf(fact_102_ord__le__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A4: A,B3: A,F: A > B,C2: B] :
          ( ( ord_less_eq @ A @ A4 @ B3 )
         => ( ( ( F @ B3 )
              = C2 )
           => ( ! [X4: A,Y4: A] :
                  ( ( ord_less_eq @ A @ X4 @ Y4 )
                 => ( ord_less_eq @ B @ ( F @ X4 ) @ ( F @ Y4 ) ) )
             => ( ord_less_eq @ B @ ( F @ A4 ) @ C2 ) ) ) ) ) ).

% ord_le_eq_subst
thf(fact_103_ord__eq__le__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A4: A,F: B > A,B3: B,C2: B] :
          ( ( A4
            = ( F @ B3 ) )
         => ( ( ord_less_eq @ B @ B3 @ C2 )
           => ( ! [X4: B,Y4: B] :
                  ( ( ord_less_eq @ B @ X4 @ Y4 )
                 => ( ord_less_eq @ A @ ( F @ X4 ) @ ( F @ Y4 ) ) )
             => ( ord_less_eq @ A @ A4 @ ( F @ C2 ) ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_104_order__subst2,axiom,
    ! [A: $tType,C3: $tType] :
      ( ( ( order @ C3 @ ( type2 @ C3 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A4: A,B3: A,F: A > C3,C2: C3] :
          ( ( ord_less_eq @ A @ A4 @ B3 )
         => ( ( ord_less_eq @ C3 @ ( F @ B3 ) @ C2 )
           => ( ! [X4: A,Y4: A] :
                  ( ( ord_less_eq @ A @ X4 @ Y4 )
                 => ( ord_less_eq @ C3 @ ( F @ X4 ) @ ( F @ Y4 ) ) )
             => ( ord_less_eq @ C3 @ ( F @ A4 ) @ C2 ) ) ) ) ) ).

% order_subst2
thf(fact_105_order__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B @ ( type2 @ B ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A4: A,F: B > A,B3: B,C2: B] :
          ( ( ord_less_eq @ A @ A4 @ ( F @ B3 ) )
         => ( ( ord_less_eq @ B @ B3 @ C2 )
           => ( ! [X4: B,Y4: B] :
                  ( ( ord_less_eq @ B @ X4 @ Y4 )
                 => ( ord_less_eq @ A @ ( F @ X4 ) @ ( F @ Y4 ) ) )
             => ( ord_less_eq @ A @ A4 @ ( F @ C2 ) ) ) ) ) ) ).

% order_subst1
thf(fact_106_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ( ( ord_less_eq @ ( A > B ) )
        = ( ^ [F2: A > B,G2: A > B] :
            ! [X6: A] : ( ord_less_eq @ B @ ( F2 @ X6 ) @ ( G2 @ X6 ) ) ) ) ) ).

% le_fun_def
thf(fact_107_le__funI,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F: A > B,G: A > B] :
          ( ! [X4: A] : ( ord_less_eq @ B @ ( F @ X4 ) @ ( G @ X4 ) )
         => ( ord_less_eq @ ( A > B ) @ F @ G ) ) ) ).

% le_funI
thf(fact_108_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F: A > B,G: A > B,X: A] :
          ( ( ord_less_eq @ ( A > B ) @ F @ G )
         => ( ord_less_eq @ B @ ( F @ X ) @ ( G @ X ) ) ) ) ).

% le_funE
thf(fact_109_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F: A > B,G: A > B,X: A] :
          ( ( ord_less_eq @ ( A > B ) @ F @ G )
         => ( ord_less_eq @ B @ ( F @ X ) @ ( G @ X ) ) ) ) ).

% le_funD
thf(fact_110_dual__order_Ostrict__implies__not__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A4: A] :
          ( ( ord_less @ A @ B3 @ A4 )
         => ( A4 != B3 ) ) ) ).

% dual_order.strict_implies_not_eq
thf(fact_111_order_Ostrict__implies__not__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A] :
          ( ( ord_less @ A @ A4 @ B3 )
         => ( A4 != B3 ) ) ) ).

% order.strict_implies_not_eq
thf(fact_112_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ~ ( ord_less @ A @ X @ Y ) )
          = ( ( ord_less @ A @ Y @ X )
            | ( X = Y ) ) ) ) ).

% not_less_iff_gr_or_eq
thf(fact_113_dual__order_Ostrict__trans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A4: A,C2: A] :
          ( ( ord_less @ A @ B3 @ A4 )
         => ( ( ord_less @ A @ C2 @ B3 )
           => ( ord_less @ A @ C2 @ A4 ) ) ) ) ).

% dual_order.strict_trans
thf(fact_114_less__imp__not__less,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less @ A @ X @ Y )
         => ~ ( ord_less @ A @ Y @ X ) ) ) ).

% less_imp_not_less
thf(fact_115_order_Ostrict__trans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A,C2: A] :
          ( ( ord_less @ A @ A4 @ B3 )
         => ( ( ord_less @ A @ B3 @ C2 )
           => ( ord_less @ A @ A4 @ C2 ) ) ) ) ).

% order.strict_trans
thf(fact_116_dual__order_Oirrefl,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A4: A] :
          ~ ( ord_less @ A @ A4 @ A4 ) ) ).

% dual_order.irrefl
thf(fact_117_linorder__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ~ ( ord_less @ A @ X @ Y )
         => ( ( X != Y )
           => ( ord_less @ A @ Y @ X ) ) ) ) ).

% linorder_cases
thf(fact_118_less__imp__triv,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,P: $o] :
          ( ( ord_less @ A @ X @ Y )
         => ( ( ord_less @ A @ Y @ X )
           => P ) ) ) ).

% less_imp_triv
thf(fact_119_less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less @ A @ X @ Y )
         => ( Y != X ) ) ) ).

% less_imp_not_eq2
thf(fact_120_antisym__conv3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Y: A,X: A] :
          ( ~ ( ord_less @ A @ Y @ X )
         => ( ( ~ ( ord_less @ A @ X @ Y ) )
            = ( X = Y ) ) ) ) ).

% antisym_conv3
thf(fact_121_less__induct,axiom,
    ! [A: $tType] :
      ( ( wellorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o,A4: A] :
          ( ! [X4: A] :
              ( ! [Y5: A] :
                  ( ( ord_less @ A @ Y5 @ X4 )
                 => ( P @ Y5 ) )
             => ( P @ X4 ) )
         => ( P @ A4 ) ) ) ).

% less_induct
thf(fact_122_less__not__sym,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less @ A @ X @ Y )
         => ~ ( ord_less @ A @ Y @ X ) ) ) ).

% less_not_sym
thf(fact_123_less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less @ A @ X @ Y )
         => ( X != Y ) ) ) ).

% less_imp_not_eq
thf(fact_124_dual__order_Oasym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A4: A] :
          ( ( ord_less @ A @ B3 @ A4 )
         => ~ ( ord_less @ A @ A4 @ B3 ) ) ) ).

% dual_order.asym
thf(fact_125_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A,C2: A] :
          ( ( ord_less @ A @ A4 @ B3 )
         => ( ( B3 = C2 )
           => ( ord_less @ A @ A4 @ C2 ) ) ) ) ).

% ord_less_eq_trans
thf(fact_126_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A,C2: A] :
          ( ( A4 = B3 )
         => ( ( ord_less @ A @ B3 @ C2 )
           => ( ord_less @ A @ A4 @ C2 ) ) ) ) ).

% ord_eq_less_trans
thf(fact_127_less__irrefl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A] :
          ~ ( ord_less @ A @ X @ X ) ) ).

% less_irrefl
thf(fact_128_less__linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less @ A @ X @ Y )
          | ( X = Y )
          | ( ord_less @ A @ Y @ X ) ) ) ).

% less_linear
thf(fact_129_less__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z4: A] :
          ( ( ord_less @ A @ X @ Y )
         => ( ( ord_less @ A @ Y @ Z4 )
           => ( ord_less @ A @ X @ Z4 ) ) ) ) ).

% less_trans
thf(fact_130_less__asym_H,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A] :
          ( ( ord_less @ A @ A4 @ B3 )
         => ~ ( ord_less @ A @ B3 @ A4 ) ) ) ).

% less_asym'
thf(fact_131_less__asym,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less @ A @ X @ Y )
         => ~ ( ord_less @ A @ Y @ X ) ) ) ).

% less_asym
thf(fact_132_less__imp__neq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less @ A @ X @ Y )
         => ( X != Y ) ) ) ).

% less_imp_neq
thf(fact_133_dense,axiom,
    ! [A: $tType] :
      ( ( dense_order @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less @ A @ X @ Y )
         => ? [Z: A] :
              ( ( ord_less @ A @ X @ Z )
              & ( ord_less @ A @ Z @ Y ) ) ) ) ).

% dense
thf(fact_134_order_Oasym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A] :
          ( ( ord_less @ A @ A4 @ B3 )
         => ~ ( ord_less @ A @ B3 @ A4 ) ) ) ).

% order.asym
thf(fact_135_neq__iff,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( X != Y )
          = ( ( ord_less @ A @ X @ Y )
            | ( ord_less @ A @ Y @ X ) ) ) ) ).

% neq_iff
thf(fact_136_neqE,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( X != Y )
         => ( ~ ( ord_less @ A @ X @ Y )
           => ( ord_less @ A @ Y @ X ) ) ) ) ).

% neqE
thf(fact_137_gt__ex,axiom,
    ! [A: $tType] :
      ( ( no_top @ A @ ( type2 @ A ) )
     => ! [X: A] :
        ? [X1: A] : ( ord_less @ A @ X @ X1 ) ) ).

% gt_ex
thf(fact_138_lt__ex,axiom,
    ! [A: $tType] :
      ( ( no_bot @ A @ ( type2 @ A ) )
     => ! [X: A] :
        ? [Y4: A] : ( ord_less @ A @ Y4 @ X ) ) ).

% lt_ex
thf(fact_139_order__less__subst2,axiom,
    ! [A: $tType,C3: $tType] :
      ( ( ( order @ C3 @ ( type2 @ C3 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A4: A,B3: A,F: A > C3,C2: C3] :
          ( ( ord_less @ A @ A4 @ B3 )
         => ( ( ord_less @ C3 @ ( F @ B3 ) @ C2 )
           => ( ! [X4: A,Y4: A] :
                  ( ( ord_less @ A @ X4 @ Y4 )
                 => ( ord_less @ C3 @ ( F @ X4 ) @ ( F @ Y4 ) ) )
             => ( ord_less @ C3 @ ( F @ A4 ) @ C2 ) ) ) ) ) ).

% order_less_subst2
thf(fact_140_order__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B @ ( type2 @ B ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A4: A,F: B > A,B3: B,C2: B] :
          ( ( ord_less @ A @ A4 @ ( F @ B3 ) )
         => ( ( ord_less @ B @ B3 @ C2 )
           => ( ! [X4: B,Y4: B] :
                  ( ( ord_less @ B @ X4 @ Y4 )
                 => ( ord_less @ A @ ( F @ X4 ) @ ( F @ Y4 ) ) )
             => ( ord_less @ A @ A4 @ ( F @ C2 ) ) ) ) ) ) ).

% order_less_subst1
thf(fact_141_ord__less__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A4: A,B3: A,F: A > B,C2: B] :
          ( ( ord_less @ A @ A4 @ B3 )
         => ( ( ( F @ B3 )
              = C2 )
           => ( ! [X4: A,Y4: A] :
                  ( ( ord_less @ A @ X4 @ Y4 )
                 => ( ord_less @ B @ ( F @ X4 ) @ ( F @ Y4 ) ) )
             => ( ord_less @ B @ ( F @ A4 ) @ C2 ) ) ) ) ) ).

% ord_less_eq_subst
thf(fact_142_ord__eq__less__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A4: A,F: B > A,B3: B,C2: B] :
          ( ( A4
            = ( F @ B3 ) )
         => ( ( ord_less @ B @ B3 @ C2 )
           => ( ! [X4: B,Y4: B] :
                  ( ( ord_less @ B @ X4 @ Y4 )
                 => ( ord_less @ A @ ( F @ X4 ) @ ( F @ Y4 ) ) )
             => ( ord_less @ A @ A4 @ ( F @ C2 ) ) ) ) ) ) ).

% ord_eq_less_subst
thf(fact_143_bst__eq_Osimps_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [L2: tree @ A,A4: A,R2: tree @ A] :
          ( ( linorder_bst_eq @ A @ ( node @ A @ L2 @ A4 @ R2 ) )
          = ( ( linorder_bst_eq @ A @ L2 )
            & ( linorder_bst_eq @ A @ R2 )
            & ! [X6: A] :
                ( ( member @ A @ X6 @ ( set_tree @ A @ L2 ) )
               => ( ord_less_eq @ A @ X6 @ A4 ) )
            & ! [X6: A] :
                ( ( member @ A @ X6 @ ( set_tree @ A @ R2 ) )
               => ( ord_less_eq @ A @ A4 @ X6 ) ) ) ) ) ).

% bst_eq.simps(2)
thf(fact_144_bst__eq_Oelims_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: tree @ A] :
          ( ~ ( linorder_bst_eq @ A @ X )
         => ~ ! [L: tree @ A,A6: A,R: tree @ A] :
                ( ( X
                  = ( node @ A @ L @ A6 @ R ) )
               => ( ( linorder_bst_eq @ A @ L )
                  & ( linorder_bst_eq @ A @ R )
                  & ! [X4: A] :
                      ( ( member @ A @ X4 @ ( set_tree @ A @ L ) )
                     => ( ord_less_eq @ A @ X4 @ A6 ) )
                  & ! [X4: A] :
                      ( ( member @ A @ X4 @ ( set_tree @ A @ R ) )
                     => ( ord_less_eq @ A @ A6 @ X4 ) ) ) ) ) ) ).

% bst_eq.elims(3)
thf(fact_145_leD,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Y: A,X: A] :
          ( ( ord_less_eq @ A @ Y @ X )
         => ~ ( ord_less @ A @ X @ Y ) ) ) ).

% leD
thf(fact_146_leI,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ~ ( ord_less @ A @ X @ Y )
         => ( ord_less_eq @ A @ Y @ X ) ) ) ).

% leI
thf(fact_147_le__less,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [X6: A,Y2: A] :
              ( ( ord_less @ A @ X6 @ Y2 )
              | ( X6 = Y2 ) ) ) ) ) ).

% le_less
thf(fact_148_less__le,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less @ A )
        = ( ^ [X6: A,Y2: A] :
              ( ( ord_less_eq @ A @ X6 @ Y2 )
              & ( X6 != Y2 ) ) ) ) ) ).

% less_le
thf(fact_149_order__le__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B @ ( type2 @ B ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A4: A,F: B > A,B3: B,C2: B] :
          ( ( ord_less_eq @ A @ A4 @ ( F @ B3 ) )
         => ( ( ord_less @ B @ B3 @ C2 )
           => ( ! [X4: B,Y4: B] :
                  ( ( ord_less @ B @ X4 @ Y4 )
                 => ( ord_less @ A @ ( F @ X4 ) @ ( F @ Y4 ) ) )
             => ( ord_less @ A @ A4 @ ( F @ C2 ) ) ) ) ) ) ).

% order_le_less_subst1
thf(fact_150_order__le__less__subst2,axiom,
    ! [A: $tType,C3: $tType] :
      ( ( ( order @ C3 @ ( type2 @ C3 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A4: A,B3: A,F: A > C3,C2: C3] :
          ( ( ord_less_eq @ A @ A4 @ B3 )
         => ( ( ord_less @ C3 @ ( F @ B3 ) @ C2 )
           => ( ! [X4: A,Y4: A] :
                  ( ( ord_less_eq @ A @ X4 @ Y4 )
                 => ( ord_less_eq @ C3 @ ( F @ X4 ) @ ( F @ Y4 ) ) )
             => ( ord_less @ C3 @ ( F @ A4 ) @ C2 ) ) ) ) ) ).

% order_le_less_subst2
thf(fact_151_order__less__le__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B @ ( type2 @ B ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A4: A,F: B > A,B3: B,C2: B] :
          ( ( ord_less @ A @ A4 @ ( F @ B3 ) )
         => ( ( ord_less_eq @ B @ B3 @ C2 )
           => ( ! [X4: B,Y4: B] :
                  ( ( ord_less_eq @ B @ X4 @ Y4 )
                 => ( ord_less_eq @ A @ ( F @ X4 ) @ ( F @ Y4 ) ) )
             => ( ord_less @ A @ A4 @ ( F @ C2 ) ) ) ) ) ) ).

% order_less_le_subst1
thf(fact_152_order__less__le__subst2,axiom,
    ! [A: $tType,C3: $tType] :
      ( ( ( order @ C3 @ ( type2 @ C3 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A4: A,B3: A,F: A > C3,C2: C3] :
          ( ( ord_less @ A @ A4 @ B3 )
         => ( ( ord_less_eq @ C3 @ ( F @ B3 ) @ C2 )
           => ( ! [X4: A,Y4: A] :
                  ( ( ord_less @ A @ X4 @ Y4 )
                 => ( ord_less @ C3 @ ( F @ X4 ) @ ( F @ Y4 ) ) )
             => ( ord_less @ C3 @ ( F @ A4 ) @ C2 ) ) ) ) ) ).

% order_less_le_subst2
thf(fact_153_not__le,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ~ ( ord_less_eq @ A @ X @ Y ) )
          = ( ord_less @ A @ Y @ X ) ) ) ).

% not_le
thf(fact_154_not__less,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ~ ( ord_less @ A @ X @ Y ) )
          = ( ord_less_eq @ A @ Y @ X ) ) ) ).

% not_less
thf(fact_155_le__neq__trans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A] :
          ( ( ord_less_eq @ A @ A4 @ B3 )
         => ( ( A4 != B3 )
           => ( ord_less @ A @ A4 @ B3 ) ) ) ) ).

% le_neq_trans
thf(fact_156_less__imp__le,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less @ A @ X @ Y )
         => ( ord_less_eq @ A @ X @ Y ) ) ) ).

% less_imp_le
thf(fact_157_antisym__conv1,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ~ ( ord_less @ A @ X @ Y )
         => ( ( ord_less_eq @ A @ X @ Y )
            = ( X = Y ) ) ) ) ).

% antisym_conv1
thf(fact_158_antisym__conv2,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ~ ( ord_less @ A @ X @ Y ) )
            = ( X = Y ) ) ) ) ).

% antisym_conv2
thf(fact_159_le__less__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z4: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ord_less @ A @ Y @ Z4 )
           => ( ord_less @ A @ X @ Z4 ) ) ) ) ).

% le_less_trans
thf(fact_160_less__le__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z4: A] :
          ( ( ord_less @ A @ X @ Y )
         => ( ( ord_less_eq @ A @ Y @ Z4 )
           => ( ord_less @ A @ X @ Z4 ) ) ) ) ).

% less_le_trans
thf(fact_161_dense__ge,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A @ ( type2 @ A ) )
     => ! [Z4: A,Y: A] :
          ( ! [X4: A] :
              ( ( ord_less @ A @ Z4 @ X4 )
             => ( ord_less_eq @ A @ Y @ X4 ) )
         => ( ord_less_eq @ A @ Y @ Z4 ) ) ) ).

% dense_ge
thf(fact_162_dense__le,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A @ ( type2 @ A ) )
     => ! [Y: A,Z4: A] :
          ( ! [X4: A] :
              ( ( ord_less @ A @ X4 @ Y )
             => ( ord_less_eq @ A @ X4 @ Z4 ) )
         => ( ord_less_eq @ A @ Y @ Z4 ) ) ) ).

% dense_le
thf(fact_163_le__less__linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
          | ( ord_less @ A @ Y @ X ) ) ) ).

% le_less_linear
thf(fact_164_le__imp__less__or__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ord_less @ A @ X @ Y )
            | ( X = Y ) ) ) ) ).

% le_imp_less_or_eq
thf(fact_165_less__le__not__le,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ( ( ord_less @ A )
        = ( ^ [X6: A,Y2: A] :
              ( ( ord_less_eq @ A @ X6 @ Y2 )
              & ~ ( ord_less_eq @ A @ Y2 @ X6 ) ) ) ) ) ).

% less_le_not_le
thf(fact_166_not__le__imp__less,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Y: A,X: A] :
          ( ~ ( ord_less_eq @ A @ Y @ X )
         => ( ord_less @ A @ X @ Y ) ) ) ).

% not_le_imp_less
thf(fact_167_order_Ostrict__trans1,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A,C2: A] :
          ( ( ord_less_eq @ A @ A4 @ B3 )
         => ( ( ord_less @ A @ B3 @ C2 )
           => ( ord_less @ A @ A4 @ C2 ) ) ) ) ).

% order.strict_trans1
thf(fact_168_order_Ostrict__trans2,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A,C2: A] :
          ( ( ord_less @ A @ A4 @ B3 )
         => ( ( ord_less_eq @ A @ B3 @ C2 )
           => ( ord_less @ A @ A4 @ C2 ) ) ) ) ).

% order.strict_trans2
thf(fact_169_order_Oorder__iff__strict,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [A5: A,B4: A] :
              ( ( ord_less @ A @ A5 @ B4 )
              | ( A5 = B4 ) ) ) ) ) ).

% order.order_iff_strict
thf(fact_170_order_Ostrict__iff__order,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less @ A )
        = ( ^ [A5: A,B4: A] :
              ( ( ord_less_eq @ A @ A5 @ B4 )
              & ( A5 != B4 ) ) ) ) ) ).

% order.strict_iff_order
thf(fact_171_dual__order_Ostrict__trans1,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A4: A,C2: A] :
          ( ( ord_less_eq @ A @ B3 @ A4 )
         => ( ( ord_less @ A @ C2 @ B3 )
           => ( ord_less @ A @ C2 @ A4 ) ) ) ) ).

% dual_order.strict_trans1
thf(fact_172_dual__order_Ostrict__trans2,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A4: A,C2: A] :
          ( ( ord_less @ A @ B3 @ A4 )
         => ( ( ord_less_eq @ A @ C2 @ B3 )
           => ( ord_less @ A @ C2 @ A4 ) ) ) ) ).

% dual_order.strict_trans2
thf(fact_173_dense__ge__bounded,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A @ ( type2 @ A ) )
     => ! [Z4: A,X: A,Y: A] :
          ( ( ord_less @ A @ Z4 @ X )
         => ( ! [W: A] :
                ( ( ord_less @ A @ Z4 @ W )
               => ( ( ord_less @ A @ W @ X )
                 => ( ord_less_eq @ A @ Y @ W ) ) )
           => ( ord_less_eq @ A @ Y @ Z4 ) ) ) ) ).

% dense_ge_bounded
thf(fact_174_dense__le__bounded,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z4: A] :
          ( ( ord_less @ A @ X @ Y )
         => ( ! [W: A] :
                ( ( ord_less @ A @ X @ W )
               => ( ( ord_less @ A @ W @ Y )
                 => ( ord_less_eq @ A @ W @ Z4 ) ) )
           => ( ord_less_eq @ A @ Y @ Z4 ) ) ) ) ).

% dense_le_bounded
thf(fact_175_order_Ostrict__implies__order,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A] :
          ( ( ord_less @ A @ A4 @ B3 )
         => ( ord_less_eq @ A @ A4 @ B3 ) ) ) ).

% order.strict_implies_order
thf(fact_176_dual__order_Oorder__iff__strict,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [B4: A,A5: A] :
              ( ( ord_less @ A @ B4 @ A5 )
              | ( A5 = B4 ) ) ) ) ) ).

% dual_order.order_iff_strict
thf(fact_177_bst__eq_Opelims_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: tree @ A,Y: $o] :
          ( ( ( linorder_bst_eq @ A @ X )
            = Y )
         => ( ( accp @ ( tree @ A ) @ ( linorder_bst_eq_rel @ A ) @ X )
           => ( ( ( X
                  = ( leaf @ A ) )
               => ( Y
                 => ~ ( accp @ ( tree @ A ) @ ( linorder_bst_eq_rel @ A ) @ ( leaf @ A ) ) ) )
             => ~ ! [L: tree @ A,A6: A,R: tree @ A] :
                    ( ( X
                      = ( node @ A @ L @ A6 @ R ) )
                   => ( ( Y
                        = ( ( linorder_bst_eq @ A @ L )
                          & ( linorder_bst_eq @ A @ R )
                          & ! [X6: A] :
                              ( ( member @ A @ X6 @ ( set_tree @ A @ L ) )
                             => ( ord_less_eq @ A @ X6 @ A6 ) )
                          & ! [X6: A] :
                              ( ( member @ A @ X6 @ ( set_tree @ A @ R ) )
                             => ( ord_less_eq @ A @ A6 @ X6 ) ) ) )
                     => ~ ( accp @ ( tree @ A ) @ ( linorder_bst_eq_rel @ A ) @ ( node @ A @ L @ A6 @ R ) ) ) ) ) ) ) ) ).

% bst_eq.pelims(1)
thf(fact_178_bst__eq_Opelims_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: tree @ A] :
          ( ( linorder_bst_eq @ A @ X )
         => ( ( accp @ ( tree @ A ) @ ( linorder_bst_eq_rel @ A ) @ X )
           => ( ( ( X
                  = ( leaf @ A ) )
               => ~ ( accp @ ( tree @ A ) @ ( linorder_bst_eq_rel @ A ) @ ( leaf @ A ) ) )
             => ~ ! [L: tree @ A,A6: A,R: tree @ A] :
                    ( ( X
                      = ( node @ A @ L @ A6 @ R ) )
                   => ( ( accp @ ( tree @ A ) @ ( linorder_bst_eq_rel @ A ) @ ( node @ A @ L @ A6 @ R ) )
                     => ~ ( ( linorder_bst_eq @ A @ L )
                          & ( linorder_bst_eq @ A @ R )
                          & ! [X5: A] :
                              ( ( member @ A @ X5 @ ( set_tree @ A @ L ) )
                             => ( ord_less_eq @ A @ X5 @ A6 ) )
                          & ! [X5: A] :
                              ( ( member @ A @ X5 @ ( set_tree @ A @ R ) )
                             => ( ord_less_eq @ A @ A6 @ X5 ) ) ) ) ) ) ) ) ) ).

% bst_eq.pelims(2)
thf(fact_179_bst__eq_Opelims_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: tree @ A] :
          ( ~ ( linorder_bst_eq @ A @ X )
         => ( ( accp @ ( tree @ A ) @ ( linorder_bst_eq_rel @ A ) @ X )
           => ~ ! [L: tree @ A,A6: A,R: tree @ A] :
                  ( ( X
                    = ( node @ A @ L @ A6 @ R ) )
                 => ( ( accp @ ( tree @ A ) @ ( linorder_bst_eq_rel @ A ) @ ( node @ A @ L @ A6 @ R ) )
                   => ( ( linorder_bst_eq @ A @ L )
                      & ( linorder_bst_eq @ A @ R )
                      & ! [X4: A] :
                          ( ( member @ A @ X4 @ ( set_tree @ A @ L ) )
                         => ( ord_less_eq @ A @ X4 @ A6 ) )
                      & ! [X4: A] :
                          ( ( member @ A @ X4 @ ( set_tree @ A @ R ) )
                         => ( ord_less_eq @ A @ A6 @ X4 ) ) ) ) ) ) ) ) ).

% bst_eq.pelims(3)
thf(fact_180_minf_I8_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ X5 @ Z )
         => ~ ( ord_less_eq @ A @ T @ X5 ) ) ) ).

% minf(8)
thf(fact_181_minf_I6_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ X5 @ Z )
         => ( ord_less_eq @ A @ X5 @ T ) ) ) ).

% minf(6)
thf(fact_182_pinf_I8_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ Z @ X5 )
         => ( ord_less_eq @ A @ T @ X5 ) ) ) ).

% pinf(8)
thf(fact_183_less__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ( ( ord_less @ ( A > B ) )
        = ( ^ [F2: A > B,G2: A > B] :
              ( ( ord_less_eq @ ( A > B ) @ F2 @ G2 )
              & ~ ( ord_less_eq @ ( A > B ) @ G2 @ F2 ) ) ) ) ) ).

% less_fun_def
thf(fact_184_minf_I11_J,axiom,
    ! [C3: $tType,D2: $tType] :
      ( ( ord @ C3 @ ( type2 @ C3 ) )
     => ! [F3: D2] :
        ? [Z: C3] :
        ! [X5: C3] :
          ( ( ord_less @ C3 @ X5 @ Z )
         => ( F3 = F3 ) ) ) ).

% minf(11)
thf(fact_185_minf_I7_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ X5 @ Z )
         => ~ ( ord_less @ A @ T @ X5 ) ) ) ).

% minf(7)
thf(fact_186_minf_I5_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ X5 @ Z )
         => ( ord_less @ A @ X5 @ T ) ) ) ).

% minf(5)
thf(fact_187_minf_I4_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ X5 @ Z )
         => ( X5 != T ) ) ) ).

% minf(4)
thf(fact_188_minf_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ X5 @ Z )
         => ( X5 != T ) ) ) ).

% minf(3)
thf(fact_189_minf_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o,P3: A > $o,Q: A > $o,Q2: A > $o] :
          ( ? [Z6: A] :
            ! [X4: A] :
              ( ( ord_less @ A @ X4 @ Z6 )
             => ( ( P @ X4 )
                = ( P3 @ X4 ) ) )
         => ( ? [Z6: A] :
              ! [X4: A] :
                ( ( ord_less @ A @ X4 @ Z6 )
               => ( ( Q @ X4 )
                  = ( Q2 @ X4 ) ) )
           => ? [Z: A] :
              ! [X5: A] :
                ( ( ord_less @ A @ X5 @ Z )
               => ( ( ( P @ X5 )
                    | ( Q @ X5 ) )
                  = ( ( P3 @ X5 )
                    | ( Q2 @ X5 ) ) ) ) ) ) ) ).

% minf(2)
thf(fact_190_minf_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o,P3: A > $o,Q: A > $o,Q2: A > $o] :
          ( ? [Z6: A] :
            ! [X4: A] :
              ( ( ord_less @ A @ X4 @ Z6 )
             => ( ( P @ X4 )
                = ( P3 @ X4 ) ) )
         => ( ? [Z6: A] :
              ! [X4: A] :
                ( ( ord_less @ A @ X4 @ Z6 )
               => ( ( Q @ X4 )
                  = ( Q2 @ X4 ) ) )
           => ? [Z: A] :
              ! [X5: A] :
                ( ( ord_less @ A @ X5 @ Z )
               => ( ( ( P @ X5 )
                    & ( Q @ X5 ) )
                  = ( ( P3 @ X5 )
                    & ( Q2 @ X5 ) ) ) ) ) ) ) ).

% minf(1)
thf(fact_191_pinf_I11_J,axiom,
    ! [C3: $tType,D2: $tType] :
      ( ( ord @ C3 @ ( type2 @ C3 ) )
     => ! [F3: D2] :
        ? [Z: C3] :
        ! [X5: C3] :
          ( ( ord_less @ C3 @ Z @ X5 )
         => ( F3 = F3 ) ) ) ).

% pinf(11)
thf(fact_192_pinf_I7_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ Z @ X5 )
         => ( ord_less @ A @ T @ X5 ) ) ) ).

% pinf(7)
thf(fact_193_pinf_I5_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ Z @ X5 )
         => ~ ( ord_less @ A @ X5 @ T ) ) ) ).

% pinf(5)
thf(fact_194_pinf_I4_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ Z @ X5 )
         => ( X5 != T ) ) ) ).

% pinf(4)
thf(fact_195_pinf_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ Z @ X5 )
         => ( X5 != T ) ) ) ).

% pinf(3)
thf(fact_196_pinf_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o,P3: A > $o,Q: A > $o,Q2: A > $o] :
          ( ? [Z6: A] :
            ! [X4: A] :
              ( ( ord_less @ A @ Z6 @ X4 )
             => ( ( P @ X4 )
                = ( P3 @ X4 ) ) )
         => ( ? [Z6: A] :
              ! [X4: A] :
                ( ( ord_less @ A @ Z6 @ X4 )
               => ( ( Q @ X4 )
                  = ( Q2 @ X4 ) ) )
           => ? [Z: A] :
              ! [X5: A] :
                ( ( ord_less @ A @ Z @ X5 )
               => ( ( ( P @ X5 )
                    | ( Q @ X5 ) )
                  = ( ( P3 @ X5 )
                    | ( Q2 @ X5 ) ) ) ) ) ) ) ).

% pinf(2)
thf(fact_197_pinf_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o,P3: A > $o,Q: A > $o,Q2: A > $o] :
          ( ? [Z6: A] :
            ! [X4: A] :
              ( ( ord_less @ A @ Z6 @ X4 )
             => ( ( P @ X4 )
                = ( P3 @ X4 ) ) )
         => ( ? [Z6: A] :
              ! [X4: A] :
                ( ( ord_less @ A @ Z6 @ X4 )
               => ( ( Q @ X4 )
                  = ( Q2 @ X4 ) ) )
           => ? [Z: A] :
              ! [X5: A] :
                ( ( ord_less @ A @ Z @ X5 )
               => ( ( ( P @ X5 )
                    & ( Q @ X5 ) )
                  = ( ( P3 @ X5 )
                    & ( Q2 @ X5 ) ) ) ) ) ) ) ).

% pinf(1)
thf(fact_198_pinf_I6_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ Z @ X5 )
         => ~ ( ord_less_eq @ A @ X5 @ T ) ) ) ).

% pinf(6)
thf(fact_199_t__splay__simps_I6_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [B3: A,A4: A,L2: tree @ A] :
          ( ( ord_less @ A @ B3 @ A4 )
         => ( ( splay_914434265_splay @ A @ A4 @ ( node @ A @ L2 @ B3 @ ( leaf @ A ) ) )
            = ( one_one @ nat ) ) ) ) ).

% t_splay_simps(6)
thf(fact_200_t__splay__simps_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A,R2: tree @ A] :
          ( ( ord_less @ A @ A4 @ B3 )
         => ( ( splay_914434265_splay @ A @ A4 @ ( node @ A @ ( leaf @ A ) @ B3 @ R2 ) )
            = ( one_one @ nat ) ) ) ) ).

% t_splay_simps(2)
thf(fact_201_t__splay__simps_I7_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [B3: A,A4: A,L2: tree @ A,Rl2: tree @ A,Rr2: tree @ A] :
          ( ( ord_less @ A @ B3 @ A4 )
         => ( ( splay_914434265_splay @ A @ A4 @ ( node @ A @ L2 @ B3 @ ( node @ A @ Rl2 @ A4 @ Rr2 ) ) )
            = ( one_one @ nat ) ) ) ) ).

% t_splay_simps(7)
thf(fact_202_t__splay__simps_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A4: A,L2: tree @ A,R2: tree @ A] :
          ( ( splay_914434265_splay @ A @ A4 @ ( node @ A @ L2 @ A4 @ R2 ) )
          = ( one_one @ nat ) ) ) ).

% t_splay_simps(1)
thf(fact_203_t__splay__simps_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A,Ll: tree @ A,Lr: tree @ A,R2: tree @ A] :
          ( ( ord_less @ A @ A4 @ B3 )
         => ( ( splay_914434265_splay @ A @ A4 @ ( node @ A @ ( node @ A @ Ll @ A4 @ Lr ) @ B3 @ R2 ) )
            = ( one_one @ nat ) ) ) ) ).

% t_splay_simps(3)
thf(fact_204_t__splay_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A4: A] :
          ( ( splay_914434265_splay @ A @ A4 @ ( leaf @ A ) )
          = ( one_one @ nat ) ) ) ).

% t_splay.simps(1)
thf(fact_205_less__numeral__extra_I4_J,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type2 @ A ) )
     => ~ ( ord_less @ A @ ( one_one @ A ) @ ( one_one @ A ) ) ) ).

% less_numeral_extra(4)
thf(fact_206_le__numeral__extra_I4_J,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type2 @ A ) )
     => ( ord_less_eq @ A @ ( one_one @ A ) @ ( one_one @ A ) ) ) ).

% le_numeral_extra(4)
thf(fact_207_t__splay__simps_I9_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [B3: A,A4: A,C2: A,Rr2: tree @ A,L2: tree @ A,Rl2: tree @ A] :
          ( ( ord_less @ A @ B3 @ A4 )
         => ( ( ord_less @ A @ C2 @ A4 )
           => ( ( ( Rr2
                  = ( leaf @ A ) )
               => ( ( splay_914434265_splay @ A @ A4 @ ( node @ A @ L2 @ B3 @ ( node @ A @ Rl2 @ C2 @ Rr2 ) ) )
                  = ( one_one @ nat ) ) )
              & ( ( Rr2
                 != ( leaf @ A ) )
               => ( ( splay_914434265_splay @ A @ A4 @ ( node @ A @ L2 @ B3 @ ( node @ A @ Rl2 @ C2 @ Rr2 ) ) )
                  = ( plus_plus @ nat @ ( splay_914434265_splay @ A @ A4 @ Rr2 ) @ ( one_one @ nat ) ) ) ) ) ) ) ) ).

% t_splay_simps(9)
thf(fact_208_t__splay__simps_I8_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [B3: A,A4: A,C2: A,Rl2: tree @ A,L2: tree @ A,Rr2: tree @ A] :
          ( ( ord_less @ A @ B3 @ A4 )
         => ( ( ord_less @ A @ A4 @ C2 )
           => ( ( ( Rl2
                  = ( leaf @ A ) )
               => ( ( splay_914434265_splay @ A @ A4 @ ( node @ A @ L2 @ B3 @ ( node @ A @ Rl2 @ C2 @ Rr2 ) ) )
                  = ( one_one @ nat ) ) )
              & ( ( Rl2
                 != ( leaf @ A ) )
               => ( ( splay_914434265_splay @ A @ A4 @ ( node @ A @ L2 @ B3 @ ( node @ A @ Rl2 @ C2 @ Rr2 ) ) )
                  = ( plus_plus @ nat @ ( splay_914434265_splay @ A @ A4 @ Rl2 ) @ ( one_one @ nat ) ) ) ) ) ) ) ) ).

% t_splay_simps(8)
thf(fact_209_t__splay__simps_I4_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A,C2: A,Ll: tree @ A,Lr: tree @ A,R2: tree @ A] :
          ( ( ord_less @ A @ A4 @ B3 )
         => ( ( ord_less @ A @ A4 @ C2 )
           => ( ( ( Ll
                  = ( leaf @ A ) )
               => ( ( splay_914434265_splay @ A @ A4 @ ( node @ A @ ( node @ A @ Ll @ C2 @ Lr ) @ B3 @ R2 ) )
                  = ( one_one @ nat ) ) )
              & ( ( Ll
                 != ( leaf @ A ) )
               => ( ( splay_914434265_splay @ A @ A4 @ ( node @ A @ ( node @ A @ Ll @ C2 @ Lr ) @ B3 @ R2 ) )
                  = ( plus_plus @ nat @ ( splay_914434265_splay @ A @ A4 @ Ll ) @ ( one_one @ nat ) ) ) ) ) ) ) ) ).

% t_splay_simps(4)
thf(fact_210_t__splay__simps_I5_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A,C2: A,Lr: tree @ A,Ll: tree @ A,R2: tree @ A] :
          ( ( ord_less @ A @ A4 @ B3 )
         => ( ( ord_less @ A @ C2 @ A4 )
           => ( ( ( Lr
                  = ( leaf @ A ) )
               => ( ( splay_914434265_splay @ A @ A4 @ ( node @ A @ ( node @ A @ Ll @ C2 @ Lr ) @ B3 @ R2 ) )
                  = ( one_one @ nat ) ) )
              & ( ( Lr
                 != ( leaf @ A ) )
               => ( ( splay_914434265_splay @ A @ A4 @ ( node @ A @ ( node @ A @ Ll @ C2 @ Lr ) @ B3 @ R2 ) )
                  = ( plus_plus @ nat @ ( splay_914434265_splay @ A @ A4 @ Lr ) @ ( one_one @ nat ) ) ) ) ) ) ) ) ).

% t_splay_simps(5)
thf(fact_211_add__less__cancel__right,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type2 @ A ) )
     => ! [A4: A,C2: A,B3: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ A4 @ C2 ) @ ( plus_plus @ A @ B3 @ C2 ) )
          = ( ord_less @ A @ A4 @ B3 ) ) ) ).

% add_less_cancel_right
thf(fact_212_add__less__cancel__left,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type2 @ A ) )
     => ! [C2: A,A4: A,B3: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ C2 @ A4 ) @ ( plus_plus @ A @ C2 @ B3 ) )
          = ( ord_less @ A @ A4 @ B3 ) ) ) ).

% add_less_cancel_left
thf(fact_213_add__le__cancel__left,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type2 @ A ) )
     => ! [C2: A,A4: A,B3: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ C2 @ A4 ) @ ( plus_plus @ A @ C2 @ B3 ) )
          = ( ord_less_eq @ A @ A4 @ B3 ) ) ) ).

% add_le_cancel_left
thf(fact_214_add__le__cancel__right,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type2 @ A ) )
     => ! [A4: A,C2: A,B3: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ A4 @ C2 ) @ ( plus_plus @ A @ B3 @ C2 ) )
          = ( ord_less_eq @ A @ A4 @ B3 ) ) ) ).

% add_le_cancel_right
thf(fact_215_add__mono__thms__linordered__semiring_I3_J,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A @ ( type2 @ A ) )
     => ! [I: A,J: A,K: A,L2: A] :
          ( ( ( ord_less_eq @ A @ I @ J )
            & ( K = L2 ) )
         => ( ord_less_eq @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L2 ) ) ) ) ).

% add_mono_thms_linordered_semiring(3)
thf(fact_216_add__mono__thms__linordered__semiring_I2_J,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A @ ( type2 @ A ) )
     => ! [I: A,J: A,K: A,L2: A] :
          ( ( ( I = J )
            & ( ord_less_eq @ A @ K @ L2 ) )
         => ( ord_less_eq @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L2 ) ) ) ) ).

% add_mono_thms_linordered_semiring(2)
thf(fact_217_add__mono__thms__linordered__semiring_I1_J,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A @ ( type2 @ A ) )
     => ! [I: A,J: A,K: A,L2: A] :
          ( ( ( ord_less_eq @ A @ I @ J )
            & ( ord_less_eq @ A @ K @ L2 ) )
         => ( ord_less_eq @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L2 ) ) ) ) ).

% add_mono_thms_linordered_semiring(1)
thf(fact_218_add__mono,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A,C2: A,D3: A] :
          ( ( ord_less_eq @ A @ A4 @ B3 )
         => ( ( ord_less_eq @ A @ C2 @ D3 )
           => ( ord_less_eq @ A @ ( plus_plus @ A @ A4 @ C2 ) @ ( plus_plus @ A @ B3 @ D3 ) ) ) ) ) ).

% add_mono
thf(fact_219_add__left__mono,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A,C2: A] :
          ( ( ord_less_eq @ A @ A4 @ B3 )
         => ( ord_less_eq @ A @ ( plus_plus @ A @ C2 @ A4 ) @ ( plus_plus @ A @ C2 @ B3 ) ) ) ) ).

% add_left_mono
thf(fact_220_add__right__mono,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A,C2: A] :
          ( ( ord_less_eq @ A @ A4 @ B3 )
         => ( ord_less_eq @ A @ ( plus_plus @ A @ A4 @ C2 ) @ ( plus_plus @ A @ B3 @ C2 ) ) ) ) ).

% add_right_mono
thf(fact_221_le__iff__add,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [A5: A,B4: A] :
            ? [C4: A] :
              ( B4
              = ( plus_plus @ A @ A5 @ C4 ) ) ) ) ) ).

% le_iff_add
thf(fact_222_add__le__imp__le__left,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type2 @ A ) )
     => ! [C2: A,A4: A,B3: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ C2 @ A4 ) @ ( plus_plus @ A @ C2 @ B3 ) )
         => ( ord_less_eq @ A @ A4 @ B3 ) ) ) ).

% add_le_imp_le_left
thf(fact_223_add__le__imp__le__right,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type2 @ A ) )
     => ! [A4: A,C2: A,B3: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ A4 @ C2 ) @ ( plus_plus @ A @ B3 @ C2 ) )
         => ( ord_less_eq @ A @ A4 @ B3 ) ) ) ).

% add_le_imp_le_right
thf(fact_224_add__mono__thms__linordered__field_I5_J,axiom,
    ! [A: $tType] :
      ( ( ordere223160158up_add @ A @ ( type2 @ A ) )
     => ! [I: A,J: A,K: A,L2: A] :
          ( ( ( ord_less @ A @ I @ J )
            & ( ord_less @ A @ K @ L2 ) )
         => ( ord_less @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L2 ) ) ) ) ).

% add_mono_thms_linordered_field(5)
thf(fact_225_add__mono__thms__linordered__field_I2_J,axiom,
    ! [A: $tType] :
      ( ( ordere223160158up_add @ A @ ( type2 @ A ) )
     => ! [I: A,J: A,K: A,L2: A] :
          ( ( ( I = J )
            & ( ord_less @ A @ K @ L2 ) )
         => ( ord_less @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L2 ) ) ) ) ).

% add_mono_thms_linordered_field(2)
thf(fact_226_add__mono__thms__linordered__field_I1_J,axiom,
    ! [A: $tType] :
      ( ( ordere223160158up_add @ A @ ( type2 @ A ) )
     => ! [I: A,J: A,K: A,L2: A] :
          ( ( ( ord_less @ A @ I @ J )
            & ( K = L2 ) )
         => ( ord_less @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L2 ) ) ) ) ).

% add_mono_thms_linordered_field(1)
thf(fact_227_add__strict__mono,axiom,
    ! [A: $tType] :
      ( ( strict2144017051up_add @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A,C2: A,D3: A] :
          ( ( ord_less @ A @ A4 @ B3 )
         => ( ( ord_less @ A @ C2 @ D3 )
           => ( ord_less @ A @ ( plus_plus @ A @ A4 @ C2 ) @ ( plus_plus @ A @ B3 @ D3 ) ) ) ) ) ).

% add_strict_mono
thf(fact_228_add__strict__left__mono,axiom,
    ! [A: $tType] :
      ( ( ordere223160158up_add @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A,C2: A] :
          ( ( ord_less @ A @ A4 @ B3 )
         => ( ord_less @ A @ ( plus_plus @ A @ C2 @ A4 ) @ ( plus_plus @ A @ C2 @ B3 ) ) ) ) ).

% add_strict_left_mono
thf(fact_229_add__strict__right__mono,axiom,
    ! [A: $tType] :
      ( ( ordere223160158up_add @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A,C2: A] :
          ( ( ord_less @ A @ A4 @ B3 )
         => ( ord_less @ A @ ( plus_plus @ A @ A4 @ C2 ) @ ( plus_plus @ A @ B3 @ C2 ) ) ) ) ).

% add_strict_right_mono
thf(fact_230_add__less__imp__less__left,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type2 @ A ) )
     => ! [C2: A,A4: A,B3: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ C2 @ A4 ) @ ( plus_plus @ A @ C2 @ B3 ) )
         => ( ord_less @ A @ A4 @ B3 ) ) ) ).

% add_less_imp_less_left
thf(fact_231_add__less__imp__less__right,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type2 @ A ) )
     => ! [A4: A,C2: A,B3: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ A4 @ C2 ) @ ( plus_plus @ A @ B3 @ C2 ) )
         => ( ord_less @ A @ A4 @ B3 ) ) ) ).

% add_less_imp_less_right
thf(fact_232_add__mono__thms__linordered__field_I4_J,axiom,
    ! [A: $tType] :
      ( ( ordere223160158up_add @ A @ ( type2 @ A ) )
     => ! [I: A,J: A,K: A,L2: A] :
          ( ( ( ord_less_eq @ A @ I @ J )
            & ( ord_less @ A @ K @ L2 ) )
         => ( ord_less @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L2 ) ) ) ) ).

% add_mono_thms_linordered_field(4)
thf(fact_233_add__mono__thms__linordered__field_I3_J,axiom,
    ! [A: $tType] :
      ( ( ordere223160158up_add @ A @ ( type2 @ A ) )
     => ! [I: A,J: A,K: A,L2: A] :
          ( ( ( ord_less @ A @ I @ J )
            & ( ord_less_eq @ A @ K @ L2 ) )
         => ( ord_less @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L2 ) ) ) ) ).

% add_mono_thms_linordered_field(3)
thf(fact_234_add__le__less__mono,axiom,
    ! [A: $tType] :
      ( ( ordere223160158up_add @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A,C2: A,D3: A] :
          ( ( ord_less_eq @ A @ A4 @ B3 )
         => ( ( ord_less @ A @ C2 @ D3 )
           => ( ord_less @ A @ ( plus_plus @ A @ A4 @ C2 ) @ ( plus_plus @ A @ B3 @ D3 ) ) ) ) ) ).

% add_le_less_mono
thf(fact_235_add__less__le__mono,axiom,
    ! [A: $tType] :
      ( ( ordere223160158up_add @ A @ ( type2 @ A ) )
     => ! [A4: A,B3: A,C2: A,D3: A] :
          ( ( ord_less @ A @ A4 @ B3 )
         => ( ( ord_less_eq @ A @ C2 @ D3 )
           => ( ord_less @ A @ ( plus_plus @ A @ A4 @ C2 ) @ ( plus_plus @ A @ B3 @ D3 ) ) ) ) ) ).

% add_less_le_mono
thf(fact_236_discrete,axiom,
    ! [A: $tType] :
      ( ( semiring_numeral_div @ A @ ( type2 @ A ) )
     => ( ( ord_less @ A )
        = ( ^ [A5: A] : ( ord_less_eq @ A @ ( plus_plus @ A @ A5 @ ( one_one @ A ) ) ) ) ) ) ).

% discrete
thf(fact_237_less__add__one,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type2 @ A ) )
     => ! [A4: A] : ( ord_less @ A @ A4 @ ( plus_plus @ A @ A4 @ ( one_one @ A ) ) ) ) ).

% less_add_one
thf(fact_238_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( X != Y )
         => ( ~ ( ord_less @ A @ X @ Y )
           => ( ord_less @ A @ Y @ X ) ) ) ) ).

% linorder_neqE_linordered_idom
thf(fact_239_nat__add__left__cancel__le,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( plus_plus @ nat @ K @ M ) @ ( plus_plus @ nat @ K @ N ) )
      = ( ord_less_eq @ nat @ M @ N ) ) ).

% nat_add_left_cancel_le
thf(fact_240_t__splay__max_Osimps_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Rr2: tree @ A,L2: tree @ A,B3: A,Rl2: tree @ A,C2: A] :
          ( ( ( Rr2
              = ( leaf @ A ) )
           => ( ( splay_878424299ay_max @ A @ ( node @ A @ L2 @ B3 @ ( node @ A @ Rl2 @ C2 @ Rr2 ) ) )
              = ( one_one @ nat ) ) )
          & ( ( Rr2
             != ( leaf @ A ) )
           => ( ( splay_878424299ay_max @ A @ ( node @ A @ L2 @ B3 @ ( node @ A @ Rl2 @ C2 @ Rr2 ) ) )
              = ( plus_plus @ nat @ ( splay_878424299ay_max @ A @ Rr2 ) @ ( one_one @ nat ) ) ) ) ) ) ).

% t_splay_max.simps(3)
thf(fact_241_less__mono__imp__le__mono,axiom,
    ! [F: nat > nat,I: nat,J: nat] :
      ( ! [I2: nat,J2: nat] :
          ( ( ord_less @ nat @ I2 @ J2 )
         => ( ord_less @ nat @ ( F @ I2 ) @ ( F @ J2 ) ) )
     => ( ( ord_less_eq @ nat @ I @ J )
       => ( ord_less_eq @ nat @ ( F @ I ) @ ( F @ J ) ) ) ) ).

% less_mono_imp_le_mono
thf(fact_242_le__neq__implies__less,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
     => ( ( M != N )
       => ( ord_less @ nat @ M @ N ) ) ) ).

% le_neq_implies_less
thf(fact_243_less__or__eq__imp__le,axiom,
    ! [M: nat,N: nat] :
      ( ( ( ord_less @ nat @ M @ N )
        | ( M = N ) )
     => ( ord_less_eq @ nat @ M @ N ) ) ).

% less_or_eq_imp_le
thf(fact_244_le__eq__less__or__eq,axiom,
    ( ( ord_less_eq @ nat )
    = ( ^ [M2: nat,N2: nat] :
          ( ( ord_less @ nat @ M2 @ N2 )
          | ( M2 = N2 ) ) ) ) ).

% le_eq_less_or_eq
thf(fact_245_less__imp__le__nat,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ N )
     => ( ord_less_eq @ nat @ M @ N ) ) ).

% less_imp_le_nat
thf(fact_246_nat__less__le,axiom,
    ( ( ord_less @ nat )
    = ( ^ [M2: nat,N2: nat] :
          ( ( ord_less_eq @ nat @ M2 @ N2 )
          & ( M2 != N2 ) ) ) ) ).

% nat_less_le
thf(fact_247_le__refl,axiom,
    ! [N: nat] : ( ord_less_eq @ nat @ N @ N ) ).

% le_refl
thf(fact_248_le__trans,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ( ord_less_eq @ nat @ J @ K )
       => ( ord_less_eq @ nat @ I @ K ) ) ) ).

% le_trans
thf(fact_249_eq__imp__le,axiom,
    ! [M: nat,N: nat] :
      ( ( M = N )
     => ( ord_less_eq @ nat @ M @ N ) ) ).

% eq_imp_le
thf(fact_250_le__antisym,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
     => ( ( ord_less_eq @ nat @ N @ M )
       => ( M = N ) ) ) ).

% le_antisym
thf(fact_251_nat__le__linear,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
      | ( ord_less_eq @ nat @ N @ M ) ) ).

% nat_le_linear
thf(fact_252_mono__nat__linear__lb,axiom,
    ! [F: nat > nat,M: nat,K: nat] :
      ( ! [M3: nat,N3: nat] :
          ( ( ord_less @ nat @ M3 @ N3 )
         => ( ord_less @ nat @ ( F @ M3 ) @ ( F @ N3 ) ) )
     => ( ord_less_eq @ nat @ ( plus_plus @ nat @ ( F @ M ) @ K ) @ ( F @ ( plus_plus @ nat @ M @ K ) ) ) ) ).

% mono_nat_linear_lb
thf(fact_253_add__leE,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( plus_plus @ nat @ M @ K ) @ N )
     => ~ ( ( ord_less_eq @ nat @ M @ N )
         => ~ ( ord_less_eq @ nat @ K @ N ) ) ) ).

% add_leE
thf(fact_254_le__add1,axiom,
    ! [N: nat,M: nat] : ( ord_less_eq @ nat @ N @ ( plus_plus @ nat @ N @ M ) ) ).

% le_add1
thf(fact_255_le__add2,axiom,
    ! [N: nat,M: nat] : ( ord_less_eq @ nat @ N @ ( plus_plus @ nat @ M @ N ) ) ).

% le_add2

%----Subclasses (4)
thf(subcl_Orderings_Olinorder___HOL_Otype,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( type @ A @ ( type2 @ A ) ) ) ).

thf(subcl_Orderings_Olinorder___Orderings_Oord,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( ord @ A @ ( type2 @ A ) ) ) ).

thf(subcl_Orderings_Olinorder___Orderings_Oorder,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( order @ A @ ( type2 @ A ) ) ) ).

thf(subcl_Orderings_Olinorder___Orderings_Opreorder,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( preorder @ A @ ( type2 @ A ) ) ) ).

%----Type constructors (24)
thf(tcon_fun___Orderings_Opreorder,axiom,
    ! [A9: $tType,A10: $tType] :
      ( ( preorder @ A10 @ ( type2 @ A10 ) )
     => ( preorder @ ( A9 > A10 ) @ ( type2 @ ( A9 > A10 ) ) ) ) ).

thf(tcon_fun___Orderings_Oorder,axiom,
    ! [A9: $tType,A10: $tType] :
      ( ( order @ A10 @ ( type2 @ A10 ) )
     => ( order @ ( A9 > A10 ) @ ( type2 @ ( A9 > A10 ) ) ) ) ).

thf(tcon_fun___Orderings_Oord,axiom,
    ! [A9: $tType,A10: $tType] :
      ( ( ord @ A10 @ ( type2 @ A10 ) )
     => ( ord @ ( A9 > A10 ) @ ( type2 @ ( A9 > A10 ) ) ) ) ).

thf(tcon_Nat_Onat___Conditionally__Complete__Lattices_Oconditionally__complete__linorder,axiom,
    condit1037483654norder @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ostrict__ordered__ab__semigroup__add,axiom,
    strict2144017051up_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oordered__cancel__ab__semigroup__add,axiom,
    ordere223160158up_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocanonically__ordered__monoid__add,axiom,
    canoni770627133id_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oordered__ab__semigroup__add,axiom,
    ordere779506340up_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Divides_Osemiring__numeral__div,axiom,
    semiring_numeral_div @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Owellorder,axiom,
    wellorder @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Opreorder_1,axiom,
    preorder @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Olinorder,axiom,
    linorder @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Ono__top,axiom,
    no_top @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Oorder_2,axiom,
    order @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Oord_3,axiom,
    ord @ nat @ ( type2 @ nat ) ).

thf(tcon_Set_Oset___Orderings_Opreorder_4,axiom,
    ! [A9: $tType] : ( preorder @ ( set @ A9 ) @ ( type2 @ ( set @ A9 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder_5,axiom,
    ! [A9: $tType] : ( order @ ( set @ A9 ) @ ( type2 @ ( set @ A9 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oord_6,axiom,
    ! [A9: $tType] : ( ord @ ( set @ A9 ) @ ( type2 @ ( set @ A9 ) ) ) ).

thf(tcon_HOL_Obool___Orderings_Opreorder_7,axiom,
    preorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Olinorder_8,axiom,
    linorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oorder_9,axiom,
    order @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oord_10,axiom,
    ord @ $o @ ( type2 @ $o ) ).

%----Free types (1)
thf(tfree_0,hypothesis,
    linorder @ a @ ( type2 @ a ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    member @ a @ xa @ ( set_tree @ a @ lb ) ).

%------------------------------------------------------------------------------
